% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpicrust2.R
\name{ggpicrust2}
\alias{ggpicrust2}
\title{This function integrates pathway name/description annotations, ten of the most advanced differential abundance (DA) methods, and visualization of DA results.}
\usage{
ggpicrust2(
  file,
  metadata,
  group,
  pathway,
  daa_method = "ALDEx2",
  ko_to_kegg = FALSE,
  p.adjust = "BH",
  order = "group",
  p_values_bar = TRUE,
  x_lab = NULL,
  select = NULL,
  reference = NULL,
  colors = NULL
)
}
\arguments{
\item{file}{A character, the file path to store picrust2 export files}

\item{metadata}{A tibble, consisting of sample information}

\item{group}{A character, name of the group}

\item{pathway}{A character, consisting of "EC", "KO", "MetaCyc"}

\item{daa_method}{A character, the chosen differential abundance analysis (DA) method}

\item{ko_to_kegg}{A character to control the conversion of KO abundance to KEGG abundance}

\item{p.adjust}{A character, the method to adjust p-values}

\item{order}{A character to control the order of the main plot rows}

\item{p_values_bar}{A character to control if the main plot has the p_values bar}

\item{x_lab}{A character to control the x-axis label name, you can choose from "feature","pathway_name" and "description"}

\item{select}{A vector consisting of pathway names to be selected}

\item{reference}{A character, a reference group level for several DA methods}

\item{colors}{A vector consisting of colors number}
}
\value{
daa.results.df, a dataframe of DA results
}
\description{
This function integrates pathway name/description annotations, ten of the most advanced differential abundance (DA) methods, and visualization of DA results.
}
\examples{
\dontrun{
# Load necessary data: abundance data and metadata
abundance_file <- "path/to/your/abundance_file.tsv"
metadata <- read.csv("path/to/your/metadata.csv")

# Run ggpicrust2 with desired parameters
results <- ggpicrust2(file = abundance_file,
                      metadata = metadata,
                      group = "your_group_column",
                      pathway = "KO",
                      daa_method = "LinDA",
                      ko_to_kegg = TRUE,
                      order = "pathway_class",
                      p_values_bar = TRUE,
                      x_lab = "pathway_name")

# Access the plot and results dataframe for the first DA method
example_plot <- results[[1]]$plot
example_results <- results[[1]]$results
}
}
