% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplot.R
\name{simplot}
\alias{simplot}
\title{simplot}
\usage{
simplot(
  file,
  query,
  window = 200,
  step = 20,
  group = FALSE,
  id,
  sep,
  sd = FALSE
)
}
\arguments{
\item{file}{alignment fast file}

\item{query}{query sequence}

\item{window}{sliding window size (bp)}

\item{step}{step size to slide the window (bp)}

\item{group}{whether grouping sequence}

\item{id}{position to extract id for grouping; only works if group = TRUE}

\item{sep}{separator to split sequence name; only works if group = TRUE}

\item{sd}{whether display standard deviation of similarity among each group; only works if group=TRUE}
}
\value{
ggplot object
}
\description{
Sequence similarity plot
}
\examples{
fas <- system.file("extdata/GVariation/sample_alignment.fa", package="ggmsa")
simplot(fas, 'CF_YL21')
}
\author{
guangchuang yu
}
