% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_helpers.R
\name{get_inset_config}
\alias{get_inset_config}
\title{Get the inset configuration from the params or coord}
\usage{
get_inset_config(inset, coord)
}
\arguments{
\item{inset}{Inset passed in as a param to the layer}

\item{coord}{Coord object for the plot}
}
\value{
Inset configuration or \code{NULL}
}
\description{
This is a helper for implementing inset-aware ggplot layers. If the \code{inset} is
missing (\code{NA}) then the default inset configuration is retrieved from the coord.
}
\examples{
# defining a new geom deriving from geom_sf()
GeomCustom <- ggplot2::ggproto("GeomCustom", ggplot2::GeomSf,
  draw_panel = function(self, data, panel_params, coord, inset = NA) {
    inset <- get_inset_config(inset, coord)

    # do something with the inset ...

    # note that this example doesn't pass on the remaining geom_sf params but
    # in real usage you would probably want to do that
    ggplot2::ggproto_parent(ggplot2::GeomSf, self)$draw_panel(data, panel_params, coord)
  },
)
}
