% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_geocode.R
\name{mutate_geocode}
\alias{mutate_geocode}
\title{Geocode a dataset}
\usage{
mutate_geocode(data, location, ...)
}
\arguments{
\item{data}{a data frame}

\item{location}{a character string specifying a location of
interest (e.g. "Baylor University")}

\item{...}{arguments to pass to \code{\link{geocode}}}
}
\value{
data with geocoded information appended as columns
}
\description{
\code{mutate_geocode} geocodes a data frame and appends the new
information to the data frame provided.
}
\examples{


df <- data.frame(
  address = c("1600 Pennsylvania Avenue, Washington DC", "", "houston texas"),
  stringsAsFactors = FALSE
)

\dontrun{ # Server response can be slow; this cuts down check time.
mutate_geocode(df, address)


library(dplyr)
df \%>\% mutate_geocode(address)
}

}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\code{\link{geocode}}
}

