% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_gradient_interactive.R
\name{scale_gradient_interactive}
\alias{scale_gradient_interactive}
\alias{scale_colour_gradient_interactive}
\alias{scale_color_gradient_interactive}
\alias{scale_fill_gradient_interactive}
\alias{scale_colour_gradient2_interactive}
\alias{scale_color_gradient2_interactive}
\alias{scale_fill_gradient2_interactive}
\alias{scale_colour_gradientn_interactive}
\alias{scale_color_gradientn_interactive}
\alias{scale_fill_gradientn_interactive}
\title{Create interactive gradient colour scales}
\usage{
scale_colour_gradient_interactive(...)

scale_color_gradient_interactive(...)

scale_fill_gradient_interactive(...)

scale_colour_gradient2_interactive(...)

scale_color_gradient2_interactive(...)

scale_fill_gradient2_interactive(...)

scale_colour_gradientn_interactive(...)

scale_color_gradientn_interactive(...)

scale_fill_gradientn_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}.}
}
\value{
An interactive scale object.
}
\description{
These scales are based on
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}},
\code{\link[=scale_fill_gradient]{scale_fill_gradient()}},
\code{\link[=scale_colour_gradient2]{scale_colour_gradient2()}},
\code{\link[=scale_fill_gradient2]{scale_fill_gradient2()}},
\code{\link[=scale_colour_gradientn]{scale_colour_gradientn()}} and
\code{\link[=scale_fill_gradientn]{scale_fill_gradientn()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive scale and interactive guide functions}{

For scales, the interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors, depending on the number of breaks (levels) and
the type of the guide used.
The guides do not accept any interactive parameter directly, they receive them from the scales.

\itemize{
\item When guide of type \code{legend} or \code{bins} is used, it will be converted to a
\code{\link[=guide_legend_interactive]{guide_legend_interactive()}} or \code{\link[=guide_bins_interactive]{guide_bins_interactive()}} respectively,
if it's not already.

The length of each scale interactive parameter vector should match the length of the breaks.
It can also be a named vector, where each name should correspond to the same break name.
It can also be defined as function that takes the breaks as input and returns a named or
unnamed vector of values as output.

The interactive parameters here, give interactivity only to the key elements of the guide.

\item When guide of type \code{colourbar} or \code{coloursteps} is used, it will be converted to a
\code{\link[=guide_colourbar_interactive]{guide_colourbar_interactive()}} or \code{\link[=guide_coloursteps_interactive]{guide_coloursteps_interactive()}}
respectively, if it's not already.

The scale interactive parameters in this case should be scalar values and give interactivity
to the colorbar only.
}

To provide interactivity to the rest of the elements of a guide, (title, labels, background, etc),
the relevant theme elements or relevant guide arguments can be used.
The \code{guide} arguments \code{title.theme} and \code{label.theme} can be defined as
\code{element_text_interactive} (in fact, they will be converted to that if they are not
already), either directly or via the theme.
See the element_*_interactive section for more details.
}

\examples{
# add interactive gradient colour scale to a ggplot -------
library(ggplot2)
library(ggiraph)

df <- expand.grid(x = 0:5, y = 0:5)
df$z <- runif(nrow(df))

p <- ggplot(df, aes(x, y, fill = z, tooltip = "tooltip")) +
  geom_raster_interactive()

# add an interactive scale (guide is colourbar)
p1 <- p + scale_fill_gradient_interactive(data_id = "colourbar",
                                          onclick = "alert(\"colourbar\")",
                                          tooltip = "colourbar")
x <- girafe(ggobj = p1)
if (interactive()) print(x)

# make the legend title interactive
p2 <- p + scale_fill_gradient_interactive(
  data_id = "colourbar",
  onclick = "alert(\"colourbar\")",
  tooltip = "colourbar",
  name = label_interactive(
    "z",
    data_id = "colourbar",
    onclick = "alert(\"colourbar\")",
    tooltip = "colourbar"
  )
)
x <- girafe(ggobj = p2)
x <- girafe_options(x,
                    opts_hover_key(girafe_css("stroke:red", text="stroke:none;fill:red")))
if (interactive()) print(x)

# make the legend labels interactive
p3 <- p + scale_fill_gradient_interactive(
  data_id = "colourbar",
  onclick = "alert(\"colourbar\")",
  tooltip = "colourbar",
  name = label_interactive(
    "z",
    data_id = "colourbar",
    onclick = "alert(\"colourbar\")",
    tooltip = "colourbar"
  ),
  labels = function(breaks) {
    br <- na.omit(breaks)
    label_interactive(
      as.character(breaks),
      data_id = paste0("colourbar", br),
      onclick = "alert(\"colourbar\")",
      tooltip = paste0("colourbar", br)
    )
  }
)
x <- girafe(ggobj = p3)
x <- girafe_options(x,
                    opts_hover_key(girafe_css("stroke:red", text="stroke:none;fill:red")))
if (interactive()) print(x)

# also via the guide
p4 <- p + scale_fill_gradient_interactive(
  data_id = "colourbar",
  onclick = "alert(\"colourbar\")",
  tooltip = "colourbar",
  guide = guide_colourbar_interactive(
    title.theme = element_text_interactive(
      size = 8,
      data_id = "colourbar",
      onclick = "alert(\"colourbar\")",
      tooltip = "colourbar"
    ),
    label.theme = element_text_interactive(
      size = 8,
      data_id = "colourbar",
      onclick = "alert(\"colourbar\")",
      tooltip = "colourbar"
    )
  )
)
x <- girafe(ggobj = p4)
x <- girafe_options(x,
                    opts_hover_key(girafe_css("stroke:red", text="stroke:none;fill:red")))
if (interactive()) print(x)

# make the legend background interactive
p5 <- p4 + theme(
  legend.background = element_rect_interactive(
    data_id = "colourbar",
    onclick = "alert(\"colourbar\")",
    tooltip = "colourbar"
  )
)
x <- girafe(ggobj = p5)
x <- girafe_options(x,
                    opts_hover_key(girafe_css("stroke:red", text="stroke:none;fill:red")))
if (interactive()) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}

Other interactive scale: 
\code{\link{scale_alpha_interactive}()},
\code{\link{scale_colour_brewer_interactive}()},
\code{\link{scale_colour_interactive}},
\code{\link{scale_colour_steps_interactive}()},
\code{\link{scale_linetype_interactive}()},
\code{\link{scale_manual_interactive}},
\code{\link{scale_shape_interactive}()},
\code{\link{scale_size_interactive}()},
\code{\link{scale_viridis_interactive}}
}
\concept{interactive scale}
