% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghilbert.R
\name{gghilbertplot}
\alias{gghilbertplot}
\title{Function to create the Hilbert Plot}
\usage{
gghilbertplot(
  df,
  idcol,
  color = NULL,
  size = NULL,
  label = NULL,
  alpha = 1,
  add_curve = FALSE,
  curve_alpha = 1,
  curve_color = "black",
  jitter = 0
)
}
\arguments{
\item{df}{Data frame to generate plot from}

\item{idcol}{The column name to be used for mapping (gghid)}

\item{color}{The column to map to color}

\item{size}{The column to map to size}

\item{label}{The column that contains the label}

\item{alpha}{The amount of alpha blending for the individual points}

\item{add_curve}{Whether or not to add the underlying hilbert curve}

\item{curve_alpha}{The amount of alpha blending for the hilbert curve}

\item{curve_color}{The color of the hilbert curve}

\item{jitter}{The amount of jitter to add to prevent overplotting}
}
\value{
a ggplot object
}
\description{
Function to create the Hilbert Plot
}
\examples{
tibble::tibble(val = 1:128, size = runif(128, 1, 5), color = rep(c(1,2,3,4),32)) \%>\%
        gghilbertplot(val, color = factor(color), size = size, add_curve = TRUE)
}
