% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_hdx.R
\name{scale_color_hdx_discrete}
\alias{scale_color_hdx_discrete}
\alias{scale_colour_hdx_discrete}
\alias{scale_color_hdx_gray}
\alias{scale_colour_hdx_gray}
\alias{scale_colour_hdx_grey}
\alias{scale_color_hdx_grey}
\alias{scale_color_hdx_mint}
\alias{scale_colour_hdx_mint}
\alias{scale_color_hdx_sapphire}
\alias{scale_colour_hdx_sapphire}
\alias{scale_color_hdx_tomato}
\alias{scale_colour_hdx_tomato}
\alias{scale_fill_hdx_discrete}
\alias{scale_fill_hdx_gray}
\alias{scale_fill_hdx_grey}
\alias{scale_fill_hdx_mint}
\alias{scale_fill_hdx_sapphire}
\alias{scale_fill_hdx_tomato}
\alias{scale_fill_gradient_hdx}
\alias{scale_fill_gradient_hdx_sapphire}
\alias{scale_fill_gradient_hdx_mint}
\alias{scale_fill_gradient_hdx_tomato}
\alias{scale_color_gradient_hdx}
\alias{scale_colour_gradient_hdx}
\alias{scale_color_gradient_hdx_sapphire}
\alias{scale_colour_gradient_hdx_sapphire}
\alias{scale_color_gradient_hdx_mint}
\alias{scale_colour_gradient_hdx_mint}
\alias{scale_color_gradient_hdx_tomato}
\alias{scale_colour_gradient_hdx_tomato}
\alias{scale_color_gradient2_hdx}
\alias{scale_colour_gradient2_hdx}
\alias{scale_fill_gradient2_hdx}
\title{HDX color scales}
\usage{
scale_color_hdx_discrete(...)

scale_colour_hdx_discrete(...)

scale_color_hdx_gray(...)

scale_colour_hdx_gray(...)

scale_colour_hdx_grey(...)

scale_color_hdx_grey(...)

scale_color_hdx_mint(...)

scale_colour_hdx_mint(...)

scale_color_hdx_sapphire(...)

scale_colour_hdx_sapphire(...)

scale_color_hdx_tomato(...)

scale_colour_hdx_tomato(...)

scale_fill_hdx_discrete(...)

scale_fill_hdx_gray(...)

scale_fill_hdx_grey(...)

scale_fill_hdx_mint(...)

scale_fill_hdx_sapphire(...)

scale_fill_hdx_tomato(...)

scale_fill_gradient_hdx(...)

scale_fill_gradient_hdx_sapphire(...)

scale_fill_gradient_hdx_mint(...)

scale_fill_gradient_hdx_tomato(...)

scale_color_gradient_hdx(...)

scale_colour_gradient_hdx(...)

scale_color_gradient_hdx_sapphire(...)

scale_colour_gradient_hdx_sapphire(...)

scale_color_gradient_hdx_mint(...)

scale_colour_gradient_hdx_mint(...)

scale_color_gradient_hdx_tomato(...)

scale_colour_gradient_hdx_tomato(...)

scale_color_gradient2_hdx(...)

scale_colour_gradient2_hdx(...)

scale_fill_gradient2_hdx(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:hue_pal]{scales::hue_pal()}}).}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\value{
Relevant ggplot2 scale object to add to a \code{ggplot2::ggplot()} plot,
either \code{ggplot2::ScaleDiscrete} or \code{ggplot2::ScaleContinuous}.
}
\description{
Color scales using the HDX palette. For discrete color scales, the
\code{scale_color_hdx_...()} and \code{scale_fill_hdx_...()} family of functions are
available. For gradient scales, use \code{scale_color_gradient_hdx()} and
\code{scale_fill_gradient_hdx()} functions for a single color scale or
\code{scale_..._gradient2...()} alternative.
}
\examples{
library(ggplot2)

# discrete scaling
p1 <- ggplot(iris) +
  geom_point(
    aes(
      x = Sepal.Length,
      y = Petal.Width,
      color = Species
    )
  )

p1

p1 + scale_color_hdx_discrete()
p1 + scale_color_hdx_mint()

# use gradient scaling
p2 <- ggplot(iris) +
  geom_point(
    aes(
      x = Sepal.Length,
      y = Petal.Width,
      color = Petal.Length
    )
  )

p2

p2 + scale_color_gradient_hdx_mint()
p2 + scale_color_gradient_hdx_tomato()

}
\seealso{
\code{\link[=gghdx]{gghdx()}} for setting default fill and color scaling,
along with other styling.
}
