% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_logticks.R
\name{guide_axis_logticks}
\alias{guide_axis_logticks}
\title{Axis guide with ticks for logarithmic breaks}
\usage{
guide_axis_logticks(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  position = waiver(),
  prescaled = FALSE,
  trunc_lower = NULL,
  trunc_upper = NULL,
  colour = NULL,
  color = NULL,
  base = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take the angles and \code{hjust}/\code{vjust} directly from the theme.
\item \code{waiver()} to allow reasonable defaults in special cases.
\item A number representing the text angle in degrees.
}}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{A positive \code{integer} of length 1 that specifies the order of
this guide among multiple guides. This controls in which order guides are
merged if there are multiple guides for the same position. If 0 (default),
the order is determined by a secret algorithm.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}

\item{prescaled}{A \code{logical} of length one, indicating whether the data
has been manually rescaled (\code{TRUE}) or the scale takes care of the
transformation (\code{FALSE}).}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{base}{When this is provided, the guide takes this as the base for the
log transformation instead of trying to guess the base. It is recommended
to use this argument if the base is not \code{10}.}
}
\value{
An \emph{axis_logticks} guide class object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This axis guide is probably best described as
\code{\link[ggplot2:annotation_logticks]{ggplot2::annotation_logticks()}} but implemented as a guide instead
of a geom. The tick marks probably best suit log10 transformations.
The function is deprecated because ggplot2 implemented a better log tick
axis.
}
\section{Theme elements}{

This axis guide uses the following the theme elements:

\describe{
\item{\code{\link[=theme_extensions]{ggh4x.axis.ticks.length.minor}}}{
An \code{\link[ggplot2:element]{rel()}} object to set the size of minor ticks
relative to the length of major ticks (\code{axis.ticks.length}).
Defaults to \code{rel(2/3)}.
}
\item{\code{\link[=theme_extensions]{ggh4x.axis.ticks.length.mini}}}{
An \code{\link[ggplot2:element]{rel()}} object to set the size of smallest ticks,
also relative to the length of major ticks (\code{axis.ticks.length}).
Defaults to \code{rel(1/3)}.
}
}
}

\examples{
# The guide works well out of the box with log10 scales
p <- ggplot(pressure, aes(temperature, pressure)) +
  geom_line()
p + scale_y_log10(guide = "axis_logticks")

# If the data is already transformed, you can set 'prescaled' to TRUE
ggplot(pressure, aes(temperature, log10(pressure))) +
  geom_line() +
  guides(y = guide_axis_logticks(prescaled = TRUE))

# The lenghts of the log-ticks are controlled by the theme relative to the
# major ticks.
p + scale_y_log10(guide = "axis_logticks") +
  theme(
    axis.ticks.length.y = unit(1, "cm"),
    ggh4x.axis.ticks.length.minor = rel(0.55),
    ggh4x.axis.ticks.length.mini = rel(0.1)
  )
}
\seealso{
Other axis-guides: 
\code{\link{guide_axis_manual}()},
\code{\link{guide_axis_minor}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_axis_scalebar}()},
\code{\link{guide_axis_truncated}()}
}
\concept{axis-guides}
\keyword{internal}
