% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggghost-package.R
\docType{package}
\name{ggghost-package}
\alias{ggghost}
\alias{ggghost-package}
\title{ggghost: Capture the spirit of your ggplot calls}
\description{
Creates a reproducible container for ggplot, storing the data and calls required to produce a plot.
}
\details{
\code{ggplot2} stores the information needed to build the graph as a \code{grob}, but
that's what the \strong{computer} needs to know about in order to build the graph.
As humans, we're more interested in what commands were issued in order to
build the graph. For good reproducibility, the calls need to be applied to the
relevant data. While this is somewhat available by deconstructing the \code{grob},
it's not the simplest approach.

Here is one option that solves that problem.

\code{ggghost} stores the data used in a \code{ggplot()} call, and collects \code{ggplot}
commands (usually separated by \code{+}) as they are applied, in effect lazily
collecting the calls. Once the object is requested, the \code{print} method
combines the individual calls back into the total plotting command and
executes it. This is where the call would usually be discarded. Instead, a
"ghost" of the commands lingers in the object for further investigation,
subsetting, adding to, or subtracting from.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jonocarroll/ggghost}
  \item Report bugs at \url{https://github.com/jonocarroll/ggghost/issues}
}

}
\author{
\strong{Maintainer}: Jonathan Carroll \email{rpkg@jcarroll.com.au}

}
\keyword{internal}
