% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_forecast.R
\name{fortify.forecast}
\alias{fortify.forecast}
\title{Convert \code{forecast::forecast} to \code{data.frame}}
\usage{
\method{fortify}{forecast}(model, data = NULL, is.date = NULL,
  ts.connect = FALSE, ...)
}
\arguments{
\item{model}{\code{forecast::forecast} instance}

\item{data}{original dataset, if needed}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12.}

\item{ts.connect}{Logical frag indicates whether connects original time-series and predicted values}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{forecast::forecast} to \code{data.frame}
}
\examples{
d.arima <- forecast::auto.arima(AirPassengers)
d.forecast <- forecast::forecast(d.arima, level = c(95), h = 50)
fortify(d.forecast)
fortify(d.forecast, ts.connect = TRUE)
}

