% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_surv.R
\name{autoplot.aareg}
\alias{autoplot.aareg}
\title{Autoplot \code{survival::aareg}}
\usage{
\method{autoplot}{aareg}(object, maxtime = NULL, surv.connect = TRUE,
  facets = TRUE, ncol = NULL, xlab = "", ylab = "", ...)
}
\arguments{
\item{object}{\code{survival::aareg} instance}

\item{maxtime}{truncate the input to the model at time "maxtime"}

\item{surv.connect}{logical frag indicates whether connects survival curve to the origin}

\item{facets}{Logical value to specify use facets}

\item{ncol}{Number of facet/subplot columns}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{...}{other arguments passed to \code{autoplot.survfit}}
}
\value{
ggplot
}
\description{
Autoplot \code{survival::aareg}
}
\examples{
library(survival)
autoplot(aareg(Surv(time, status) ~ age + sex + ph.ecog, data = lung, nmin = 1))
}

