% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggr_es.R
\name{aggr_es}
\alias{aggr_es}
\title{Aggregates event-study treatment effects.}
\usage{
aggr_es(
  object,
  rhs = 0,
  period = "post",
  aggregation = c("mean", "cumulative"),
  abbr_term = TRUE,
  ...
)
}
\arguments{
\item{object}{A model object of class \code{fixest}, where the \code{i()} operator has
been used to facilitate an "event-study" DiD design. See Examples.}

\item{rhs}{Numeric. The null hypothesis value. Defaults to 0.}

\item{period}{Keyword string or numeric sequence. Which group of periods
are we aggregating? Can either be one of three convenience strings---i.e.,
"post" (the default), "prep", or "both"---or a numeric sequence that matches
a subset of periods in the data (e.g. 6:8).}

\item{aggregation}{Character string. The aggregation type. Either "mean" (the
default) or "cumulative".}

\item{abbr_term}{Logical. Should the leading "term" column of the return
data frame be abbreviated? The default is TRUE. If FALSE, then the term
column will retain the full hypothesis test string as per usual with
\code{marginaleffects()}. Note that this information is retained as an attribute
of the return object, regardless.}

\item{...}{Additional arguments passed to \code{marginaleffects::hypotheses()}.}
}
\value{
A "tidy" data frame of aggregated (pre and/or post) treatment
effects, plus inferential information about standard errors, confidence
intervals, etc. Potentially useful information about the underlying
hypothesis test is also provided as an attribute. See Examples.
}
\description{
Aggregates post- (and/or pre-) treatment effects of an
"event-study" estimation, also known as a dynamic difference-in-differences
(DDiD) model. The event-study should have been estimated using the \code{fixest}
package, which provides a specialised \code{i()} operator for this class
of models. By default, the function will return the average post-treatment
effect (i.e. across multiple periods). However, it can also return the
cumulative post-treatment effect and can be used to aggregate pre-treatment
effects too. At its heart, \code{aggr_es()} is a convenience wrapper around
\code{marginaleffects::hypotheses()}, which is used to perform the underlying
joint hypothesis test.
}
\examples{
library(ggfixest) ## Will load fixest too

est = feols(y ~ x1 + i(period, treat, 5) | id + period, base_did)

# Default hypothesis test is a null mean post-treatment effect
(post_mean = aggr_es(est))
# The underlying hypothesis is saved as an attribute
attributes(post_mean)["hypothesis"]

# Other hypothesis and aggregation options
aggr_es(est, aggregation = "cumulative") # cumulative instead of mean effects
aggr_es(est, period = "pre")             # pre period instead of post
aggr_es(est, period = "both")            # pre & post periods separately
aggr_es(est, period = 6:8)               # specific subset of periods
aggr_es(est, rhs = -1, period = "pre")   # pre period with H0 value of 1
# Etc.

}
\seealso{
\code{\link[marginaleffects:hypotheses]{marginaleffects::hypotheses()}}
}
