% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sumloglike}
\alias{sumloglike}
\title{Calculate Summed, Log-likelihood of a Cognitive Model}
\usage{
sumloglike(pVec, pnames, allpar, parnames, model, type, dim1, dim2, dim3,
  n1idx, ise, cellidx, RT, matchcell, isr1, posdrift, nsim, bw, ncore,
  gpuid, debug)
}
\arguments{
\item{pVec}{a parameter vector}

\item{pnames}{a string vector storing the name of a parameter vector}

\item{allpar}{all parameters}

\item{parnames}{parameter names}

\item{model}{a model specification}

\item{type}{model type}

\item{dim1}{first dimension of a model}

\item{dim2}{second dimension of a model}

\item{dim3}{third dimension of a model}

\item{n1idx}{n1 order index}

\item{ise}{an index vector storing if a cell is empty.}

\item{cellidx}{cell index}

\item{RT}{a RT vector}

\item{matchcell}{an index vector storing is the cell is a match response}

\item{isr1}{is r1 index}

\item{posdrift}{a Boolean switch to enforce postive drift rate correction}

\item{nsim}{number of simulation}

\item{bw}{bandwidth}

\item{ncore}{number of parallel core}

\item{gpuid}{GPU card index on a multiple GPU machine}

\item{debug}{whether to print debugging information
for assuming drift rates are drawn from a normal distribution.}
}
\value{
a double scalar
}
\description{
The function calculates log-likelihood for every trial.  The input must
be a data model instance.
}
\examples{
m1 <- BuildModel(
  p.map     = list(a = "1", v = "1", z = "1", d = "1", sz = "1", sv = "1",
              t0 = "1", st0 = "1"),
  constants = c(st0 = 0, d = 0),
  match.map = list(M = list(s1 = "r1", s2 = "r2")),
  factors   = list(S = c("s1", "s2")),
  responses = c("r1", "r2"),
  type      = "rd")

p.vector <- c(a = 1, v = 1, z = 0.5, sz = 0.25, sv = 0.2, t0 = .15)

## Set up a model-data instance
dat <- simulate(m1, 128, ps = p.vector)
dmi <- BuildDMI(dat, m1)
## sumloglike(p.vector, dmi)
## [1] 0.3796048
}
