% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetConstIdx}
\alias{GetConstIdx}
\title{Whether a hyper-prior distribution is set constant}
\usage{
GetConstIdx(ppprior)
}
\arguments{
\item{ppprior}{hyper-parameter prior distributions. First element is a
location prior and second is a scale prior.}
}
\value{
\code{isConstant} gives a npar x 2 matrix;
}
\description{
Check if a prior distribution for a location and scale parameter is set
constant. \code{testHyper} checks if the parameter names in location and
in scale match.
}
\examples{
model <- BuildModel(p.map = list(A = "1", B = "R", t0 = "1",
  mean_v = c("F", "M"), sd_v = "M", st0 = "1"),
  match.map = list(M = list(s1=1, s2=2)),
  factors   = list(S = c("s1", "s2"),F = c("f1", "f2")),
    constants = c(sd_v.false = 1, st0 = 0),
    responses = c("r1", "r2"),
    type      = "norm")
  npar <- length(GetPNames(model))

## Population distribution, rate effect on F
  pop.mean <- c(A=.4, B.r1=.6, B.r2=.8, t0=.3, mean_v.f1.true=1.5,
    mean_v.f2.true=1, mean_v.f1.false=0, mean_v.f2.false=0,
    sd_v.true = .25)
    pop.scale <-c(A=.1, B.r1=.1, B.r2=.1, t0=.05, mean_v.f1.true=.2,
      mean_v.f2.true=.2, mean_v.f1.false=.2, mean_v.f2.false=.2,
      sd_v.true = .1)
    p.prior <- BuildPrior(
        dists = rep("tnorm", npar),
        p1    = pop.mean,
        p2    = pop.scale*5,
        lower = c(0,0,0,.1,NA,NA,NA,NA,0),
        upper = c(NA,NA,NA,NA,NA,NA,NA,NA,NA))
    mu.prior <- BuildPrior(
        dists = rep("tnorm", npar),
        p1    = pop.mean,
        p2    = c(1,1,1,1,2,2,2,2,1),
        lower = c(0,0,0,.1,NA,NA,NA,NA,0),
        upper = c(NA,NA,NA,NA,NA,NA,NA,NA,NA))
    sigma.prior <- BuildPrior(
        dists = rep("beta", npar),
        p1    = c(A=1, B.r1=1, B.r2=1, t0=1, mean_v.f1.true=1,
          mean_v.f2.true=1, mean_v.f1.false=1, mean_v.f2.false=1,
          sd_v.true = 1),
          p2    = rep(1, npar))
    pp.prior <- list(mu.prior, sigma.prior)

    test1 <- GetConstIdx(pp.prior)
    test2 <- lapply(pp.prior,function(x){
      lapply(x,function(y){attr(y,"dist") == "constant"})})
}
