% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted_quantile}
\alias{weighted_quantile}
\alias{weighted_quantile_fun}
\title{Weighted sample quantiles}
\usage{
weighted_quantile(
  x,
  probs = seq(0, 1, 0.25),
  weights = NULL,
  n = NULL,
  na.rm = FALSE,
  type = 7
)

weighted_quantile_fun(x, weights = NULL, n = NULL, na.rm = FALSE, type = 7)
}
\arguments{
\item{x}{numeric vector: sample values}

\item{probs}{numeric vector: probabilities in \eqn{[0, 1]}}

\item{weights}{Weights for the sample. One of:
\itemize{
\item numeric vector of same length as \code{x}: weights for corresponding values in \code{x},
which will be normalized to sum to 1.
\item \code{NULL}: indicates no weights are provided, so unweighted sample quantiles
(equivalent to \code{\link[=quantile]{quantile()}}) are returned.
}}

\item{n}{Presumed effective sample size. If this is greater than 1 and
continuous quantiles (\code{type >= 4}) are requested, flat regions may be added
to the approximation to the inverse CDF in areas where the normalized
weight exceeds \code{1/n} (i.e., regions of high density). This can be used to
ensure that if a sample of size \code{n} with duplicate \code{x} values is summarized
into a weighted sample without duplicates, the result of \code{weighted_quantile(..., n = n)}
on the weighted sample is equal to the result of \code{quantile()} on the original
sample. One of:
\itemize{
\item \code{NULL}: do not make a sample size adjustment.
\item numeric: presumed effective sample size.
\item function or name of function (as a string): A function applied to
\code{weights} (prior to normalization) to determine the sample size. Some
useful values may be:
\itemize{
\item \code{"length"}: i.e. use the number of elements in \code{weights} (equivalently
in \code{x}) as the effective sample size.
\item \code{"sum"}: i.e. use the sum of the unnormalized \code{weights} as the sample
size. Useful if the provided \code{weights} is unnormalized so that its
sum represents the true sample size.
}
}}

\item{na.rm}{logical: if \code{TRUE}, corresponding entries in \code{x} and \code{weights}
are removed if either is \code{NA}.}

\item{type}{integer between 1 and 9: determines the type of quantile estimator
to be used. Types 1 to 3 are for discontinuous quantiles, types 4 to 9 are
for continuous quantiles. See \strong{Details}.}
}
\value{
\code{weighted_quantile()} returns a numeric vector of \code{length(probs)} with the
estimate of the corresponding quantile from \code{probs}.

\code{weighted_quantile_fun()} returns a function that takes a single argument,
a vector of probabilities, which itself returns the corresponding quantile
estimates. It may be useful when \code{weighted_quantile()} needs to be called
repeatedly for the same sample, re-using some pre-computation.
}
\description{
A variation of \code{\link[=quantile]{quantile()}} that can be applied to weighted samples.
}
\details{
Calculates weighted quantiles using a variation of the quantile types based
on a generalization of \code{\link[=quantile]{quantile()}}.

Type 1--3 (discontinuous) quantiles are directly a function of the inverse
CDF as a step function, and so can be directly translated to the weighted
case using the natural definition of the weighted ECDF as the cumulative
sum of the normalized weights.

Type 4--9 (continuous) quantiles require some translation from the definitions
in \code{\link[=quantile]{quantile()}}. \code{\link[=quantile]{quantile()}} defines continuous estimators in terms of
\eqn{x_k}, which is the \eqn{k}th order statistic, and \eqn{p_k}, which is a function of \eqn{k}
and \eqn{n} (the sample size). In the weighted case, we instead take \eqn{x_k} as the \eqn{k}th
smallest value of \eqn{x} in the weighted sample (not necessarily an order statistic,
because of the weights). Then we can re-write the formulas for \eqn{p_k} in terms of
\eqn{F(x_k)} (the empirical CDF at \eqn{x_k}, i.e. the cumulative sum of normalized
weights) and \eqn{f(x_k)} (the normalized weight at \eqn{x_k}), by using the
fact that, in the unweighted case, \eqn{k = F(x_k) \cdot n} and \eqn{1/n = f(x_k)}:

\describe{
\item{Type 4}{\eqn{p_k = \frac{k}{n} = F(x_k)}}
\item{Type 5}{\eqn{p_k = \frac{k - 0.5}{n} = F(x_k) - \frac{f(x_k)}{2}}}
\item{Type 6}{\eqn{p_k = \frac{k}{n + 1} = \frac{F(x_k)}{1 + f(x_k)}}}
\item{Type 7}{\eqn{p_k = \frac{k - 1}{n - 1} = \frac{F(x_k) - f(x_k)}{1 - f(x_k)}}}
\item{Type 8}{\eqn{p_k = \frac{k - 1/3}{n + 1/3} = \frac{F(x_k) - f(x_k)/3}{1 + f(x_k)/3}}}
\item{Type 9}{\eqn{p_k = \frac{k - 3/8}{n + 1/4} = \frac{F(x_k) - f(x_k) \cdot 3/8}{1 + f(x_k)/4}}}
}

Then the quantile function (inverse CDF) is the piece-wise linear function
defined by the points \eqn{(p_k, x_k)}.
}
\seealso{
\code{\link[=weighted_ecdf]{weighted_ecdf()}}
}
