% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diverging_bar_chart.R
\name{diverging_bar_chart}
\alias{diverging_bar_chart}
\title{Diverging Bar Chart}
\usage{
diverging_bar_chart(
  data,
  x,
  y,
  bar_colors = c("#1F77B4", "#FF7F0E"),
  text_color = "black",
  text_size = 10
)
}
\arguments{
\item{data}{Dataset to use for the diverging bar chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y}{\code{numeric} column of \code{data} representing the bar length}

\item{bar_colors}{A \code{character} vector of length 2 containing the colors
for the positive and negative bars}

\item{text_color}{\code{character}. The color for the bar annotations}

\item{text_size}{\code{numeric}. The size of the bar annotation text in pt}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a diverging bar chart
}
\examples{
if (requireNamespace("tidyr")) {
  library(magrittr)
  data(biomedicalrevenue)
  biomedicalrevenue \%>\%
  dplyr::filter(year > 2016) \%>\%
  tidyr::pivot_wider(
    values_from = revenue,
    names_from = year,
    names_prefix = "revenue_"
  ) \%>\%
  dplyr::mutate(diff = revenue_2018 - revenue_2017) \%>\%
  diverging_bar_chart(company, diff)
}

data(mtcars)
mtcars_z <- dplyr::transmute(
  .data = mtcars,
  model = row.names(mtcars),
  hpz = scale(hp)
)

diverging_bar_chart(mtcars_z, model, hpz)

## Change the colors
diverging_bar_chart(mtcars_z, model, hpz, bar_color = c("darkgreen", "darkred"))

## Increase the axis label font size
diverging_bar_chart(mtcars_z, model, hpz, text_size = 14)

## Display the axis label text in the same color as the bars
diverging_bar_chart(mtcars_z, model, hpz, text_color = c("#1F77B4", "#FF7F0E"))

}
\author{
Thomas Neitmann
}
