% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode_orientation.R
\name{mode_orientation_to_x}
\alias{mode_orientation_to_x}
\alias{mode_orientation_to_y}
\title{Orientate a mode used outside of a \verb{gg_*} context}
\usage{
mode_orientation_to_x()

mode_orientation_to_y()
}
\value{
ggplot2 theme components.
}
\description{
Add theme components to a mode used outside of a \verb{gg_*} context
\itemize{
\item \code{mode_orientation_to_x()} Orientate the plot to the x axis.
\item \code{mode_orientation_to_y()} Orientate the plot to the y axis.
}
}
\examples{
library(ggplot2)
library(palmerpenguins)

penguins |>
  ggplot() +
  geom_point(aes(x = flipper_length_mm, y = body_mass_g)) +
  light_mode_r() +
  mode_orientation_to_x()


penguins |>
  ggplot() +
  geom_bar(aes(y = island)) +
  light_mode_r() +
  mode_orientation_to_y()

}
