% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self-adjoin.r
\name{self-adjoin}
\alias{self-adjoin}
\alias{self_adjoin}
\title{Adjoin a dataset to itself}
\usage{
self_adjoin(
  data,
  key,
  by = NULL,
  link = NULL,
  keep.x = NULL,
  keep.y = NULL,
  suffix = c(".x", ".y")
)
}
\arguments{
\item{data}{A data frame in lodes form (repeated measures data; see
\code{\link{alluvial-data}}).}

\item{key}{Column of \code{data} indicating sequential collection; handled as in
\code{\link[tidyr:spread]{tidyr::spread()}}.}

\item{by}{Character vector of variables to self-adjoin by; passed to
\code{\link[dplyr:join]{dplyr::join}} functions.}

\item{link}{Character vector of variables to adjoin. Will be replaced by
pairs of variables suffixed by \code{suffix}.}

\item{keep.x, keep.y}{Character vector of variables to associate with the
first (respectively, second) copy of \code{data} after adjoining. These
variables can overlap with each other but cannot overlap with \code{by} or
\code{link}.}

\item{suffix}{Suffixes to add to the adjoined \code{link} variables; passed to
\code{\link[dplyr:join]{dplyr::join}} functions.}
}
\description{
This function binds a dataset to itself along adjacent pairs of a \code{key}
variable. It is invoked by \code{\link[=geom_flow]{geom_flow()}} to convert data in lodes
form to something similar to alluvia form.
}
\details{
\code{self_adjoin} invokes \code{\link[dplyr:join]{dplyr::join}} functions in order to convert
a dataset with measures along a discrete \code{key} variable into a dataset
consisting of column bindings of these measures (by any \code{by} variables) along
adjacent values of \code{key}.
}
\examples{
# self-adjoin `majors` data
data(majors)
major_changes <- self_adjoin(majors, key = semester,
                             by = "student", link = c("semester", "curriculum"))
major_changes$change <- major_changes$curriculum.x == major_changes$curriculum.y
head(major_changes)

# self-adjoin `vaccinations` data
data(vaccinations)
vaccination_steps <- self_adjoin(vaccinations, key = survey, by = "subject",
                                 link = c("survey", "response"),
                                 keep.x = c("freq", "a"))
head(vaccination_steps)
vaccination_steps <- self_adjoin(vaccinations, key = survey, by = "subject",
                                 link = c("survey", "response"),
                                 keep.x = c("freq", "a"), keep.y = "a")
head(vaccination_steps)
}
\seealso{
Other alluvial data manipulation: 
\code{\link{alluvial-data}}
}
\concept{alluvial data manipulation}
