% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-facet-sector.R
\name{facet_sector}
\alias{facet_sector}
\title{Polar coordinates with Facet support}
\usage{
facet_sector(facets, radial = NULL, spacing_theta = pi/180, drop = TRUE)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{radial}{A Polar \link[ggplot2:ggplot2-ggproto]{Coord} created by \code{\link[=coord_circle]{coord_circle()}}.}

\item{spacing_theta}{The size of spacing between different panel. A numeric
of the radians or a \code{\link[ggplot2:element]{rel()}} object.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}
}
\description{
Draw each panel in a sector of the polar coordinate.
}
\examples{
ggplot(mtcars, aes(disp, mpg)) +
    geom_point() +
    facet_sector(
        vars(cyl),
        coord_circle(
            start = -0.4 * pi, end = 0.4 * pi, inner.radius = 0.3,
            outer.radius = 0.8, expand = TRUE
        )
    )
}
