% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-hclust.R
\name{align_hclust}
\alias{align_hclust}
\title{Reorder or Group observations based on hierarchical clustering}
\usage{
align_hclust(
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs",
  reorder_dendrogram = FALSE,
  reorder_group = FALSE,
  k = NULL,
  h = NULL,
  cutree = NULL,
  data = NULL,
  active = NULL
)
}
\arguments{
\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \code{\link[stats:dist]{dist}}
object directly or a function return a \code{\link[stats:dist]{dist}} object. Use
\code{NULL}, if you don't want to calculate the distance.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). You can also provide a function which
accepts the calculated distance (or the input matrix if \code{distance} is \code{NULL})
and returns a \code{\link[stats:hclust]{hclust}} object. Alternative, you can supply
an object which can be coerced to \code{\link[stats:hclust]{hclust}}.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}

\item{reorder_dendrogram}{A single boolean value indicating whether to
reorder the dendrogram based on the means. Alternatively, you can provide a
custom function that accepts an \code{\link[stats:hclust]{hclust}} object and the data
used to generate the tree, returning either an \code{\link[stats:hclust]{hclust}} or
\code{\link[stats:dendrogram]{dendrogram}} object. Default is \code{FALSE}.}

\item{reorder_group}{A single boolean value, indicates whether we should do
Hierarchical Clustering between groups, only used when previous groups have
been established. Default: \code{FALSE}.}

\item{k}{An integer scalar indicates the desired number of groups.}

\item{h}{A numeric scalar indicates heights where the tree should be cut.}

\item{cutree}{A function used to cut the \code{\link[stats:hclust]{hclust}} tree. It
should accept four arguments: the \code{\link[stats:hclust]{hclust}} tree object,
\code{distance} (only applicable when \code{method} is a string or a function for
performing hierarchical clustering), \code{k} (the number of clusters), and \code{h}
(the height at which to cut the tree). By default,
\code{\link[stats:cutree]{cutree()}} is used.}

\item{data}{A matrix-like object. By default, it inherits from the layout
\code{matrix}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function aligns observations within the layout according to a
hierarchical clustering tree, enabling reordering or grouping of elements
based on clustering results.
}
\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
# align_hclust won't add a dendrogram
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_hclust(k = 3L)
}
\seealso{
\code{\link[=hclust2]{hclust2()}}
}
