% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{hclust2}
\alias{hclust2}
\title{Generate Tree Structures with Hierarchical Clustering}
\usage{
hclust2(
  matrix,
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs"
)
}
\arguments{
\item{matrix}{A numeric matrix, or data frame.}

\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \code{\link[stats:dist]{dist}}
object directly or a function return a \code{\link[stats:dist]{dist}} object. Use
\code{NULL}, if you don't want to calculate the distance.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). You can also provide a function which
accepts the calculated distance (or the input matrix if \code{distance} is \code{NULL})
and returns a \code{\link[stats:hclust]{hclust}} object. Alternative, you can supply
an object which can be coerced to \code{\link[stats:hclust]{hclust}}.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}
}
\value{
A \link[stats:hclust]{hclust} object.
}
\description{
Generate Tree Structures with Hierarchical Clustering
}
\examples{
hclust2(dist(USArrests), method = "ward.D")
}
\seealso{
\itemize{
\item \link[stats:cor]{cor()}
\item \link[stats:dist]{dist()}
\item \link[stats:hclust]{hclust()}
}
}
