% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-heatmap-.R
\name{heatmap_layout}
\alias{heatmap_layout}
\alias{ggheatmap}
\title{Arrange plots in a Heatmap}
\usage{
heatmap_layout(
  data,
  mapping = aes(),
  ...,
  filling = TRUE,
  .width = NA,
  .height = NA,
  guides = waiver(),
  theme = NULL,
  set_context = TRUE,
  order = NULL,
  name = NULL
)

ggheatmap(
  data,
  mapping = aes(),
  ...,
  filling = TRUE,
  .width = NA,
  .height = NA,
  guides = waiver(),
  theme = NULL,
  set_context = TRUE,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{data}{A numeric or character vector, a data frame, and any other data
which can be converted into a matrix. Simple vector will be converted into a
one column matrix.}

\item{mapping}{Default list of aesthetic mappings to use for plot. In
addition, we will always add mapping \code{aes(.data$.x, .data$.y)}.}

\item{...}{Additional arguments passed to \link[ggplot2:geom_tile]{geom_tile}.
Only used when \code{filling = TRUE}.}

\item{filling}{A boolean value indicating whether to fill the heatmap. If you
wish to customize the filling style, set this to \code{FALSE}.

By default, the classic heatmap colour scheme
\code{\link[ggplot2:scale_gradient]{scale_fill_gradient2(low = "blue", high = "red")}}
is utilized for continuous values.
You can use the option
\code{"ggalign.heatmap_continuous_fill"} or
\code{"ggalign.heatmap_discrete_fill"} to modify the
default heatmap body fill color scale. See
\code{\link[ggplot2:scale_colour_continuous]{scale_fill_continuous()}} or
\code{\link[ggplot2:scale_colour_discrete]{scale_fill_discrete()}} for option setting
details.}

\item{.width, .height}{Heatmap body width/height, can be a \link[grid:unit]{unit} object.}

\item{guides}{A string containing one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicates which side of guide legends should be collected. If \code{NULL}, no guide legends will be collected. If \code{\link[ggplot2:waiver]{waiver()}}, it will inherit from the parent layout}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the plot area order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A \code{HeatmapLayout} object.
}
\description{
\code{ggheatmap} is an alias of \code{heatmap_layout}.
}
\section{ggplot2 specification}{

The data input in \code{ggheatmap} will be converted into the long formated data
frame when drawing. The default mapping will use \code{aes(.data$.x, .data$.y)},
you can use \code{mapping} argument to control it. The data in the underlying
\code{ggplot} object contains following columns:
\itemize{
\item \code{.xpanel} and \code{.ypanel}: the column and row panel
\item \code{.x} and \code{.y}: the \code{x} and \code{y} coordinates
\item \code{.row_names} and \code{.column_names}: A factor of the row and column names of
the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

\examples{
ggheatmap(1:10)
ggheatmap(letters)
ggheatmap(matrix(rnorm(81), nrow = 9L))
}
