% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-reorder.R
\name{align_reorder}
\alias{align_reorder}
\title{Reorders layout observations based on specific statistics.}
\usage{
align_reorder(
  stat,
  ...,
  reverse = FALSE,
  strict = TRUE,
  data = NULL,
  set_context = FALSE,
  name = NULL
)
}
\arguments{
\item{stat}{A summary function which accepts a data and returns the
statistic, which we'll call \code{\link[=order2]{order2()}} to extract the ordering information.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
function provided in \code{stat} argument.}

\item{reverse}{A boolean value. Should the sort order be in reverse?}

\item{strict}{A boolean value indicates whether the order should be strict.
If previous groups has been established, and strict is \code{FALSE}, this will
reorder the observations in each group.}

\item{data}{A matrix, data frame, or a simple vector. If an atomic vector is
provided, it will be converted into a one-column matrix. When \code{data = NULL},
the internal \code{layout} data will be used by default. Additionally, \code{data} can
be a function (including purrr-like lambdas), which will be applied to the
\code{layout} data.

It is important to note that we consider the \code{rows} as the observations. It
means the \code{NROW(data)} must return the same number with the specific \code{layout}
axis (meaning the x-axis for vertical stack layout, or y-axis for horizontal
stack layout).
\itemize{
\item \code{heatmap_layout()}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{stack_layout()}: the \code{layout} data will be used as it is since we place
all plots along a single axis.
}}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Reorders layout observations based on specific statistics.
}
\details{
The \code{align_reorder()} function differs from \code{align_order()} in that the \code{wts}
argument in \code{align_order()} must return atomic weights for each observation.
In contrast, the \code{stat} argument in \code{align_reorder()} can return more complex
structures, such as \link[stats:hclust]{hclust} or
\link[stats:dendrogram]{dendrogram}, among others.

Typically, you can achieve the functionality of \code{align_reorder()} using
\code{align_order()} by manually extracting the ordering information from
the statistic.
}
\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("l") +
    align_reorder(hclust2)
}
\seealso{
\code{\link[=order2]{order2()}}
}
