% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-.R, R/alignpatch-ggplot2.R,
%   R/alignpatch-alignpatches.R, R/alignpatch-wrap.R, R/alignpatch-patchwork.R
\name{alignpatch}
\alias{alignpatch}
\alias{patch_gtable}
\alias{patch_gtable.ggplot}
\alias{patch_gtable.alignpatches}
\alias{patch_gtable.wrapped_plot}
\alias{patch_gtable.patch}
\alias{patch_gtable.wrapped_patch}
\alias{patch_align}
\title{Building \code{alignpatches} object}
\usage{
alignpatch(x)

patch_gtable(patch, guides)

\method{patch_gtable}{ggplot}(patch, guides)

\method{patch_gtable}{alignpatches}(patch, guides)

\method{patch_gtable}{wrapped_plot}(patch, guides)

\method{patch_gtable}{patch}(patch, guides)

\method{patch_gtable}{wrapped_patch}(patch, guides)

patch_align(gt, guides, panel_width, panel_height)
}
\arguments{
\item{x}{A plot object to be prepared for alignment.}

\item{patch}{A patch to be aligned.}

\item{guides}{Input guides argument to \code{\link[=align_plots]{align_plots()}}}

\item{gt}{A \link[gtable:gtable]{gtable} object from \code{patch_gtable}.}

\item{panel_width, panel_height}{Size of the panel, if the size is \code{NA}, we
should guess the size from the aspect ratio of the \code{gt}.}
}
\value{
\itemize{
\item \code{alignpatch}: An object that implements \code{patch_gtable} method.
}

\itemize{
\item \code{patch_gtable}: A \link[gtable:gtable]{gtable} object.
}

\itemize{
\item \code{patch_align}: A list with following elements:
\itemize{
\item \code{gt}: A standard \link[gtable:gtable]{gtable} object
\item \code{width}/\code{height}: the panel width and height.
\item \code{respect}: A boolean value indicates whether to fix this panel area.
}
}
}
\description{
Prepare plots to be aligned with \code{align_plots}
\itemize{
\item \code{alignpatch}: Prepare a plot object to be aligned, the output must
implement proper \code{patch_gtable} method.
}

Extend object to be aligned with \code{align_plots}
\itemize{
\item \code{patch_table}: Convert the plot into a \link[gtable:gtable]{gtable}.
\item \code{patch_align}: Build a standard \link[gtable:gtable]{gtable} object and set the
panel width and height.
}
}
\details{
\code{ggalign} has implement \code{patch_gtable} method for following objects:
\itemize{
\item \link[ggplot2:ggplot]{ggplot}
\item \link[=align_plots]{alignpatches}
\item \link[=wrap]{wrapped_plot}
\item \link[patchwork:patchGrob]{patch}
\item \link[patchwork:wrap_elements]{wrapped_patch}
}
}
\examples{
alignpatch(ggplot())
patch_gtable(ggplot())
}
\keyword{internal}
