% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_marimekko.R
\name{stat_marimekko}
\alias{stat_marimekko}
\title{Plot two categorical variables as marimekko}
\usage{
stat_marimekko(mapping = NULL, data = NULL, show.legend = NA,
  inherit.aes = TRUE, na.rm = T, xlabelyposition = NULL, ...)
}
\arguments{
\item{mapping}{mapping}

\item{data}{data}

\item{show.legend}{logical}

\item{inherit.aes}{logical}

\item{na.rm}{logical}

\item{xlabelyposition}{position}

\item{...}{other functions
A marimekko plot, or a mosaic plot, visualises the co-occurrence of two
categorical / ordinal variables. In a time series, it could be used to
visualise the transitions from one state to another by considering each
state to be a category and plotting current category vs. next category.}
}
\description{
Plot two categorical variables as marimekko
}
\section{Aesthetics}{
 xbucket, ybucket, fill. Fill argument needs to be
assigned to ybucket., or some other column which is a one to one mapping of ybucket.
}

\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
scale_fill_continuous(low = 'green', high = 'red') +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   # strip.text = element_blank(), # useful if only one year of data
   plot.background = element_blank(),
   panel.border = element_blank(),
   panel.background  = element_blank(),
   panel.grid = element_blank(),
   panel.border = element_blank()
)
}
}

\examples{
{
library(ggplot2)
ggplot(
   data.frame(
      x1 = round(3 * runif(10000), 0),
      y1 = pmax(pmin(round(3 * rnorm(10000), 0), 3), -3),
      weight = 1:10000
   )
) +
   stat_marimekko(
      aes(
         xbucket = x1,
         ybucket = y1,
         fill = factor(y1),
         weight = weight
      ),
      xlabelyposition = 1.1,
      color = 'black'
   )}
}
