% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_survival.R
\name{gg_survival}
\alias{gg_survival}
\title{Nonparametric survival estimates.}
\usage{
gg_survival(
  interval = NULL,
  censor = NULL,
  by = NULL,
  data,
  type = c("kaplan", "nelson"),
  ...
)
}
\arguments{
\item{interval}{name of the interval variable in the training dataset.}

\item{censor}{name of the censoring variable in the training dataset.}

\item{by}{stratifying variable in the training dataset, defaults to NULL}

\item{data}{name of the training data.frame}

\item{type}{one of ("kaplan","nelson"), defaults to Kaplan-Meier}

\item{...}{extra arguments passed to Kaplan or Nelson functions.}
}
\value{
A \code{gg_survival} object created using the non-parametric Kaplan-Meier or 
Nelson-Aalen estimators.
}
\description{
Nonparametric survival estimates.
}
\details{
\code{gg_survival} is a wrapper function for generating nonparametric 
survival estimates using either \code{\link{nelson}}-Aalen or 
\code{\link{kaplan}}-Meier estimates.
}
\examples{
\dontrun{
## -------- pbc data
data(pbc, package="randomForestSRC")
pbc$time <- pbc$days/364.25

# This is the same as kaplan
gg_dta <- gg_survival(interval="time", censor="status", 
                     data=pbc)
                     
plot(gg_dta, error="none")
plot(gg_dta)

# Stratified on treatment variable.
gg_dta <- gg_survival(interval="time", censor="status", 
                     data=pbc, by="treatment")
                     
plot(gg_dta, error="none")
plot(gg_dta)

# ...with smaller confidence limits.
gg_dta <- gg_survival(interval="time", censor="status", 
                     data=pbc, by="treatment", conf.int=.68)
                     
plot(gg_dta, error="lines")
}
}
\seealso{
\code{\link{kaplan}} \code{\link{nelson}} \code{\link{plot.gg_survival}}
}
