% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_stat_qc_capability.R
\name{stat_QC_cap_hlabels}
\alias{stat_QC_cap_hlabels}
\title{horizontal Label Capability Stat}
\usage{
stat_QC_cap_hlabels(LSL, USL, method = "xBar.rBar", show = c("LSL",
  "USL"), mapping = NULL, data = NULL, inherit.aes = TRUE, ...)
}
\arguments{
\item{LSL}{numeric, Customer's lower specification limit}

\item{USL}{numeric, Customer's Upper specification limit}

\item{method}{string, calling the following methods:
\itemize{
  \item \bold{Individuals Charts}: XmR,
  \item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian
}}

\item{show}{vector, indicating which lines to draw ie., c("LCL", "LSL", "X", "USL", "UCL")
\itemize{
  \item \bold{LCL}: Lower Control Limit
  \item \bold{LSL}: Lower Specification Limit
  \item \bold{X}: Process Center
  \item \bold{USL}: Upper Specification Limit
  \item \bold{UCL}: Upper Control Limit
}}

\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
horizontal lines for histogram and density plots.
}
\description{
Draws horizontal Lables on horizontal Capability lines
}
\examples{
# Load Libraries ----------------------------------------------------------
require(ggQC)
require(ggplot2)


# Setup Data --------------------------------------------------------------
set.seed(5555)
Process1 <- data.frame(ProcessID = as.factor(rep(1,100)),
                       Value = rnorm(100,10,1),
                       Subgroup = rep(1:20, each=5),
                       Process_run_id = 1:100)
set.seed(5556)
Process2 <- data.frame(ProcessID = as.factor(rep(2,100)),
                       Value = rnorm(100,20, 1),
                       Subgroup = rep(1:10, each=10),
                       Process_run_id = 101:200)

df <- rbind(Process1, Process2)

######################
## Example 1 XmR    ##
######################
##You may need to use the r-studio Zoom for these plots or make the size of the
##stat_QC_cap_summary smaller with size = some number"

method <- "XmR"

# Normal Histogram XmR --------------------------------------------------------

EX1.1 <-  ggplot(df[df$ProcessID == 1,], aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_histogram(binwidth = 1, color="purple") +
  geom_hline(yintercept=0, color="grey") +
  stat_QC_cap_vlines(LSL = 5, USL = 15, show=c("X", "LSL", "USL"), method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, show=c("X", "LSL", "USL"), method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=2, size=4) +
  scale_x_continuous(expand =  expand_scale(mult = c(0.15,.8))) +
  ylim(0,45)
#Ex1.1

# Facet Histogram XmR -----------------------------------------------------

EX1.2 <- ggplot(df[order(df$Process_run_id),],
                aes(x=Value, QC.Subgroup=Subgroup, color=ProcessID)) +
  geom_histogram(binwidth = 1) +
  geom_hline(yintercept=0, color="grey") +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),#show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8))) +
  facet_grid(.~ProcessID) + ylim(0,45)
#EX1.2

# Facet Density Plot XmR -------------------------------------------------

EX1.3 <- ggplot(df[df$ProcessID == 1,], aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_density(bw = .4, fill="purple", trim=TRUE) +
  geom_hline(yintercept=0, color="grey") +
  stat_QC_cap_vlines(LSL = 5, USL = 15, show=c("X", "LSL", "USL"), method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, show=c("X", "LSL", "USL"), method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=2, size=4) +

  scale_x_continuous(expand =  expand_scale(mult = c(0.15,.8)))  + ylim(0,.5)
#EX1.3

# Facet Density Plot XmR --------------------------------------------------

EX1.4 <- ggplot(df[order(df$Process_run_id),],
                aes(x=Value, QC.Subgroup=Subgroup, color=ProcessID)) +
  geom_density(bw = .4, fill="grey", trim=TRUE ) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8))) +
  # geom_hline(yintercept=0, color="black") +
  facet_grid(.~ProcessID) + ylim(0,.5)
#EX1.4


########################################
##  Example 2: xBar.rBar or xBar.sBar ##
########################################

method <- "xBar.rBar" #Alternativly Use "xBar.sBar" if desired


# Single Histogram xBar.rBar ----------------------------------------------

EX2.1 <- ggplot(df[df$ProcessID==1,], aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_histogram(binwidth = 1) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8))) #+
#EX2.1


# Faceted Histogram xBar.rBar ---------------------------------------------

EX2.2 <- ggplot(df, aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_histogram(binwidth = 1) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8)))+
  facet_grid(.~ProcessID, scales="free_x")
#EX2.2

# Single Density xBar.rBar ----------------------------------------------

EX2.3 <- ggplot(df[df$ProcessID==1,], aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_density(bw = .4, fill="grey", alpha=.4) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8))) #+
#EX2.3

# Faceted Density xBar.rBar ---------------------------------------------

EX2.4 <-  ggplot(df, aes(x=Value, QC.Subgroup=Subgroup)) +
  geom_density(bw = .4, fill="grey", alpha=.4) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8)))+
  facet_grid(.~ProcessID, scales="free_x")
#EX2.4


###############################
##  Example 3: xBar.rMedian  ##
###############################

## Plots involving medians should give warning: "median based QC methods represent
## at best *potential* process capability"

##These plot work the same as in examples 2.X; below is an example.

method <- "xBar.rMedian"
EX3.1 <- ggplot(df[order(df$Process_run_id),], aes(x=Value, QC.Subgroup=Run)) +
  geom_histogram(binwidth = 1) +
  stat_QC_cap_vlines(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_vlabels(LSL = 5, USL = 15, method=method) +
  stat_QC_cap_summary(LSL = 5, USL = 15, method=method, #py=.3,
                      #show="ALL",
                      #show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk",
                      #       "LCL", "X", "UCL", "Sig"),
                      #show=c("Sig","TOL", "DNS"),
                      show=c("TOL","DNS", "Cp", "Cpk", "Pp", "Ppk"),
                      color="black", digits=4, size=4) +
  scale_x_continuous(expand =  ggplot2::expand_scale(mult = c(0.15,.8)))
#EX3.1
}
