% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxClass.R
\name{pmx_copy}
\alias{pmx_copy}
\title{Creates a deep copy of the controller}
\usage{
pmx_copy(ctr, keep_globals = FALSE, ...)
}
\arguments{
\item{ctr}{\code{pmxClass} object}

\item{keep_globals}{\code{logical} if TRUE we keep the global parameters changed by pmx_settings}

\item{...}{extra parameters passed to \code{pmx_settings}}
}
\value{
an object of \code{pmxClass}
}
\description{
Creates a deep copy of the controller
}
\details{
The controller is an `R6` object, it behaves like a reference object.
Some functions ( methods) can have a side effect on the controller and modify it internally.
Technically speaking we talk about chaining not piping here. However ,
using \code{pmx_copy} user can work on a copy of the controller.

By default the copy does not keep global parameters set using pmx_settings.
}
\examples{
ctr <- theophylline()
cctr <- ctr \%>\% pmx_copy()
## Any change in the ctr has no side effect in the ctr and vice versa
}
