% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_coord.R
\name{transform_coord}
\alias{transform_coord}
\title{Transform spatial coordinates to another projection}
\usage{
transform_coord(
  x = NULL,
  lon = NULL,
  lat = NULL,
  new.names = "auto",
  rotate = FALSE,
  proj.in = 4326,
  proj.out = NULL,
  verbose = FALSE,
  bind = FALSE,
  na = "ignore"
)
}
\arguments{
\item{x}{Data frame to be transformed. Can be omitted if numeric vectors are assigned to \code{lon} and \code{lat}.}

\item{lon, lat}{Either a name of the longitude and latitude columns in \code{x} or a numeric vector containing longitude and latitude coordinates. Use \code{NULL} to \link[=guess_coordinate_columns]{guess the longitude and/or latitude columns} in \code{x}.}

\item{new.names}{Character vector of length 2 specifying the names of transformed longitude and latitude columns, respectively. Alternatively \code{NULL}, which returns column names from \code{x} or "auto", which uses \code{NULL} if \code{bind = FALSE} and \code{c("lon.proj", "lat.proj")} if \code{bind = TRUE}.}

\item{rotate}{Logical indicating whether the projected maps should be rotated to point towards the pole relative to the mid-longitude limit.}

\item{proj.in}{The original \code{\link[sf:st_crs]{CRS}}. If \code{NULL}, the projection is taken from \code{x}. \code{x} must be a \link[sf:st]{spatial} object in that case.}

\item{proj.out}{Character. Either \code{NULL}, \code{\link[sf:st_crs]{CRS}} the coordinates should be transformed to or a name of shapefiles in \code{\link{shapefile_list}}. If \code{NULL}, the output projection will be automatically determined from data. This option requires decimal degrees as input option.}

\item{verbose}{Logical indicating whether information about the projection should be returned as message. Set to \code{FALSE} to make the function silent.}

\item{bind}{logical. Should only transformed coordinates be returned (\code{FALSE}, default) or should x be returned with transformed coordinates (\code{TRUE})?}

\item{na}{character specifying the NA action for missing coordinates. The "ignore" option ignores the coordinates and returns NAs to transformed coordinates. The "remove" option removes missing values from \code{x} returning a message while doing it. Any other character argument will trigger \code{na.fail} stopping the function in case of missing coordinates.}
}
\value{
Returns a data frame with transformed spatial coordinates.
}
\description{
Transforms spatial coordinates from original projection (decimal degrees assumed) to another projection.
}
\details{
If \code{x} is specified, the function guesses longitude and latitude columns from \code{x} by default.
}
\examples{
# Coordinates are automatically transformed to the pre-made shapefile
# projections:
x <- data.frame(lon = c(-150, 150), lat = c(60, 90))
transform_coord(x)
transform_coord(x, bind = TRUE)

x <- data.frame(lon = c(-150, 150), lat = c(20, 50))
transform_coord(x, bind = TRUE) # no transformation required.
}
\seealso{
Other basemap functions: 
\code{\link{basemap}()},
\code{\link{qmap}()},
\code{\link{shapefile_list}()}
}
\author{
Mikko Vihtakari
}
\concept{basemap functions}
