% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapefile_list.R
\name{shapefile_list}
\alias{shapefile_list}
\title{A list of pre-made shapefiles for \code{basemap}}
\usage{
shapefile_list(name, get.data = FALSE)
}
\arguments{
\item{name}{A character argument giving the name of a pre-made shapefile. Will be partially matched. Use "all" to list all available ones.}

\item{get.data}{Logical indicating whether spatial data should be returned instead of names of spatial data objects.}
}
\value{
Returns a data frame of provided pre-made shapefiles, if \code{name = "all"}. Returns a shapefile list containing the information for a particular map otherwise.
}
\description{
Lists available pre-made shapefiles for plotting in the \code{\link{basemap}} function. Gives also instructions how to make custom ones.
}
\details{
Custom shapefiles for \code{\link{basemap}} should be defined as lists with (at least) following names (everything should be provided as characters):
\itemize{
\item \strong{land} Name of the object containing land polygons. Required.
\item \strong{glacier} Name of the object containing glacier polygons. Use \code{NULL} if glaciers are not needed.
\item \strong{bathy} Name of the object containing land polygons. Use \code{NULL} if bathymetry is not needed.
}

All linked spatial data objects must be in same projection. High-resolution pre-made data are still under development and may not be available. Pre-made shapefiles contain additional elements that are used in the \code{\link{basemap}} function, but not required for custom shapefile datasets.
}
\examples{
shapefile_list("all")
shapefile_list("Arctic") # partial matching
}
\seealso{
Other basemap functions: 
\code{\link{basemap}()},
\code{\link{qmap}()},
\code{\link{transform_coord}()}
}
\author{
Mikko Vihtakari
}
\concept{basemap functions}
\keyword{shapefiles}
