% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfilogisreg.R
\name{gfilogisreg}
\alias{gfilogisreg}
\title{Generalized fiducial inference for logistic regression}
\usage{
gfilogisreg(
  formula,
  data = NULL,
  N,
  thresh = N/2,
  progress = TRUE,
  gmp = FALSE,
  ufactr = .Machine$double.eps^(-0.5),
  vfactr = .Machine$double.eps^(-0.38)
)
}
\arguments{
\item{formula}{formula describing the model}

\item{data}{dataframe containing the variables in the model}

\item{N}{number of fiducial simulations}

\item{thresh}{threshold criterion for the alteration; expert usage only}

\item{progress}{whether to print messages showing the progress of the
algorithm}

\item{gmp}{whether to use exact arithmetic in the algorithm (experimental)}

\item{ufactr, vfactr}{these are control parameters of an optimization
performed in the algorithm; these parameters should not be changed except
if you encounter some messages about convergence issues}
}
\value{
A list with two fields: \code{Beta}, the fiducial simulations of
  the parameters, and \code{Weights}, their weight.
}
\description{
Simulates the fiducial distribution of a logistic regression
  model.
}
\examples{
y <- c(0, 0, 1, 1, 1)
x <- c(-2, -1, 0, 1, 2)
gf <- gfilogisreg(y ~ x, N = 400) # (N=400 is not serious)
gfiSummary(gf)
glm(y ~ x, family = binomial())
}
