% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_estimateGas}
\alias{eth_estimateGas}
\title{Estimation of the gas.}
\usage{
eth_estimateGas(to, data)
}
\arguments{
\item{to}{Address - Address the call is send to.}

\item{data}{Data - Hash of the method signature and encoded parameters. For
details see Ethereum Contract ABI
\url{https://solidity.readthedocs.io/en/develop/abi-spec.html}.}
}
\value{
Integer - Amount of gas estimated.
}
\description{
\code{eth_estimateGas} returns an estimate of how much gas is necessary to
allow the transaction to complete.
}
\details{
The transaction will not be added to the blockchain. Note that the estimate
may be significantly more than the amount of gas actually used by the
transaction, for a variety of reasons including EVM mechanics and node
performance.
}
\examples{
\donttest{
eth_estimateGas(to = '0xcaf9a0356ddfa779fdbb55c45b22d35673550f30', data =
'0x8f8a0d1900000000000000000000000000000000000000000000000000000000000000
060000000000000000000000000000000000000000000000000000000000000002')
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}}, \code{\link{eth_call}},
  \code{\link{eth_coinbase}}, \code{\link{eth_gasPrice}},
  \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getLogs}}, \code{\link{eth_getProof}},
  \code{\link{eth_getStorageAt}},
  \code{\link{eth_getTransactionByBlockHashAndIndex}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleByBlockNumberAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
