% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/for_presentation.R
\name{for_presentation}
\alias{for_presentation}
\title{Presentation style plots}
\usage{
for_presentation(plot, aspect_ratio = 0.5, font_increase = 1.5)
}
\arguments{
\item{plot}{The ggplot2 object to be adjusted.}

\item{aspect_ratio}{The desired ratio between the height and width of the
plot, defaults to 0.5.}

\item{font_increase}{The amount to increase the font size by, default to
1.5.}
}
\value{
A plot adjusted for presentation.
}
\description{
This function adjusts the aspect ratio and default font size
of a plot to improve readability when including figures in presentations.
}
\examples{

plot <- plot_tb_burden_summary(
  countries = "United Kingdom",
  compare_all_regions = FALSE, compare_to_region = TRUE
)
plot # Original
for_presentation(plot) # After adjustments
}
\author{
Maria Bekker-Nielsen Dunbar

Sam Abbott
}
