library(testthat)
library(gestate)
library(survival)
context("Loading examples 1")
a <- Weibull(alpha=100,beta=1)
b <- Lognormal(mu=4,sigma=1.5)
c <- Exponential(lambda=0.01)
d <- Blank()
e <- PieceR(matrix(c(1,2,3,4,5,10,15,20),ncol=2),ratio=1.5)
f <- LinearR(rlength=12,Nactive=100,Ncontrol=200)
g <- GGamma(theta=30,eta=1.1,rho=2)
h <- LogLogistic(theta=6,eta=7)
i <- Gompertz(theta=8,eta=1.1)
j <- InstantR(Nactive=100,Ncontrol=97)
k <- PieceExponential(start=c(0,5,10),lambda=c(0.01,0.02,0.03))
l <- MixExp(props=c(0.7,0.3),lambda=c(0.02,0.01))
m <- MixWei(props=c(0.3,0.7),alphas=c(100,50),betas=c(1,1))
x <- c(30,1.1,2)
names(x) <- c("scale","shape","family")

context("Architecture Tests")
test_that("S4 architecture and constructors working as intended", {
  expect_match(getPDFfunction(a), "dweibull \\(x= x , scale = 100 , shape = 1 \\)")
  expect_equal(evaluateCDFfunction(b,q=exp(4)), 0.5)
  expect_equal(evaluateCDFfunction(a,10), evaluateCDFfunction(c,10))
  expect_equal(createRFfunction(d)(n=2), c(Inf,Inf))
  expect_equal(getPatients(e,x=9), 130)
  expect_equal(getRatio(e), 1.5)
  expect_equal(getNactive(e), 90)
  expect_equal(getNcontrol(f), 200)
  expect_equal(getN(f), 300)
  expect_match(getType(a), "Weibull")
  expect_match(getType(e), "PieceR")
  expect_match(getNames(g)[1], "scale")
  expect_match(getNames(g)[2], "shape")
  expect_match(getNames(g)[3], "family")
  expect_equal(getParamsV(g), x)
  expect_equal(getParams(h)[[1]], 6)
  expect_equal(getParams(h)[[2]], 7)
  expect_equal(unname(getParam(i,param=1)), 8)
  expect_equal(unname(getParam(i,param=2)), 1.1)
  expect_equal(getPatients(j,x=0.00000001), getPatients(j,x=100000000))
  expect_equal(evaluateCDFfunction(l,10), evaluateCDFfunction(m,10))
})

context("Power Tests")
test_that("Power/Event Calculators working as intended", {
  expect_equal(events2power(events=508,HR=0.75),tolerance=0.000001,0.900087)
  expect_equal(power2events(power=0.9,HR=0.75),tolerance=0.0001,507.8443)
  expect_equal(freedmanpower(events=508,HR=0.75),tolerance=0.000001,0.8961423)
  expect_equal(ZV2power(Z=1.96),tolerance=0.0001,0.5)
  expect_equal(frontierpower(events=508,HR=0.75,startpower=0.9,Eratio=0.7),tolerance=0.000001,0.8967646)
  expect_equal(events2power(events=100,HR=0.75,ratio=0.5),tolerance=0.000001,0.2729824)
  expect_equal(frontierpower(events=100,HR=0.75,startpower=0.27,Rratio=0.5,Eratio=0.35,iter=20),tolerance=0.000001,0.2148509)
})
context("Loading examples 2")
aa <- nph_traj(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,max_assessment=2)
bb <- nph_traj(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,max_assessment=30,RMST=20,landmark=20,detailed_output=TRUE,required_power=0.9)

context("nph_traj structural testing")
test_that("nph_traj runs and produces output of correct structure", {
  expect_named(aa,c("active_ecurve","control_ecurve","active_dcurve","control_dcurve","rcurve","Summary"))
  expect_s4_class(aa$active_ecurve,"Curve")
  expect_s4_class(aa$control_ecurve,"Curve")
  expect_s4_class(aa$active_dcurve,"Curve")
  expect_s4_class(aa$control_dcurve,"Curve")
  expect_s4_class(aa$rcurve,"RCurve")
  expect_named(aa$Summary,c("Time","Patients","Events_Active","Events_Control","Events_Total",
                          "HR","LogHR","LogHR_SE","Schoenfeld_Power","Frontier_Power"))
  expect_named(bb$Summary,c("Time","Patients","Events_Active","Events_Control","E_Events_Active","E_Events_Control","Events_Total",
                          "HR","LogHR","LogHR_SE","HR_CI_Upper","HR_CI_Lower","Peto_LogHR","Expected_Z",
                          "Expected_P","Log_Rank_Stat","Variance","V_Pike_Peto","Event_Ratio","Schoenfeld_Power","Event_Prop_Power","Z_Power","Frontier_Power",
                          "Estimated_SS","RMST_Restrict","RMST_Active","RMST_Control","RMST_Delta","RMST_SE","RMST_Z","RMST_Power","RMST_Failure",
                          "LM_Time","LM_Active","LM_Control","LM_Delta","LM_A_SE","LM_C_SE","LM_D_SE","LM_Z","LM_Power"))
  expect_true(is.data.frame(bb$Summary))
  expect_true(is.data.frame(bb$Summary[8,1:2]))
})

context("nph_traj numerical testing")
test_that("nph_traj is numerically correct", {
  expect_equal(as.numeric(bb$Summary[8,1:2]),c(8,200))
  expect_equal(as.numeric(bb$Summary[30,3:7]),tolerance=0.001,c(21.290,58.068,27.275,52.083,79.358))
  expect_equal(as.numeric(bb$Summary[30,8:13]),tolerance=0.0001,c(0.7001,-0.3565,0.25199,1.1472,0.4272,-0.3345))
  expect_equal(as.numeric(bb$Summary[30,14:19]),tolerance=0.0001,c(-1.4149,0.0785,-5.9855,17.896,17.901,0.3666))
  expect_equal(as.numeric(bb$Summary[30,20:23]),tolerance=0.0001,c(0.3218,0.2902,0.2929,0.2726))
  expect_equal(as.numeric(bb$Summary[10,24]),tolerance=1,c(33986))
  expect_equal(as.numeric(bb$Summary[30,25:32]),tolerance=0.0001,c(20,18.1269,17.4946,0.6323,0.5904,1.071,0.187,0))
  expect_equal(as.numeric(bb$Summary[30,33:41]),tolerance=0.0001,c(20,0.8187,0.7484,0.0703,0.0387,0.0308,0.0495,1.4203,0.2947))
})
context("Loading examples 3")
cc <- simulate_trials(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=FALSE)
dd <- simulate_trials(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=TRUE)
ee <- simulate_trials(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=10,seed=1234,output_type="list")
ff <- simulate_trials(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=TRUE,fix_events=100,output_type="list")
gg <- simulate_trials(active_ecurve=a,control_ecurve=b,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=FALSE,fix_events=10,output_type="matrix")
hh <- set_assess_time(data=ff,time=9,detailed_output=FALSE,output_type="matrix")
ii <- simulate_trials_strata(stratum_probs=c(0.5,0.5),active_ecurve=c(a,g),control_ecurve=b,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=FALSE,fix_events=10,output_type="matrix")
jj <- simulate_trials_strata(stratum_probs=c(0.5,0.5),active_ecurve=c(a,g),control_ecurve=b,rcurve=f,assess=30,iterations=10,seed=1234,detailed_output=TRUE,output_type="list")
ccc <- analyse_sim(cc,landmark=10)
ccd <- analyse_sim(cc,RMST=10,landmark=10)
eee <- analyse_sim(ee,LR=FALSE,RMST=10)
jjj <- analyse_sim(jj,landmark=20,stratum="Stratum")
cccc <- summarise_analysis(ccc)
eeee <- summarise_analysis(eee)

context("trial simulation structural testing")
test_that("simulate_trials is generating correctly-formatted output", {
  expect_true(is.matrix(cc))
  expect_identical(colnames(cc),c("Time","Censored","Trt","Iter"))
  expect_identical(colnames(dd),c("Time","Censored","Trt","Iter","ETime","CTime","Rec_Time","Assess","RCTime"))
  expect_equal(nrow(cc),3000)
  expect_true(max(cc[,"Time"]) < 30)
  expect_true(is.list(ee))
  expect_true(is.matrix(ee[[1]]))
  expect_equal(nrow(ee[[1]]),300)
  expect_identical(colnames(ee[[1]]),c("Time","Censored","Trt"))
  expect_true(is.list(ff))
  expect_true(is.matrix(ff[[1]]))
  expect_equal(nrow(ff[[1]]),300)
  expect_identical(colnames(ff[[1]]),c("Time","Censored","Trt","ETime","CTime","Rec_Time","Assess","RCTime"))
  expect_equal(sum(ff[[1]][,"Censored"],ff[[2]][,"Censored"],ff[[3]][,"Censored"],ff[[4]][,"Censored"],ff[[5]][,"Censored"],ff[[6]][,"Censored"],ff[[7]][,"Censored"],ff[[8]][,"Censored"],ff[[9]][,"Censored"],ff[[10]][,"Censored"]),2000)
  expect_true(is.matrix(gg))
  expect_equal(nrow(gg),2095)
  expect_identical(colnames(gg),c("Time","Censored","Trt","Iter"))
  expect_equal(sum(gg[,"Censored"]),1995)
})

test_that("set_assess_times is working properly", {
  expect_true(is.matrix(hh))
  expect_equal(nrow(hh),2270)
  expect_identical(colnames(hh),c("Time","Censored","Trt","Iter"))
  expect_equal(sum(hh[,"Censored"]),2147)
  expect_true(max(hh[,"Time"]) < 9)
})

test_that("simulate_trials_strata is working properly", {
  expect_true(is.matrix(ii))
  expect_equal(nrow(ii),2125)
  expect_identical(colnames(ii),c("Time","Censored","Trt","Iter","Stratum"))
  expect_equal(sum(ii[,"Censored"]),2025)
  expect_true(max(ii[,"Time"]) < 30)
  expect_true(is.list(jj))
  expect_identical(colnames(jj[[1]]),c("Time","Censored","Trt","ETime","CTime","Rec_Time","Assess","RCTime","Stratum"))
  expect_equal(nrow(jj[[1]]),300)
  expect_true(max(jj[[1]][,"Time"]) < 30)
})
context("Simulation analysis structural testing")
test_that("analyse_sim is working properly", {
  expect_true(is.matrix(ccc))
  expect_equal(nrow(ccc),10)
  expect_equal(nrow(jjj),10)
  expect_identical(colnames(ccc),c("HR","LogHR","LogHR_SE","HR_Z","HR_P","LR_Z","LR_P","Events_Active","Events_Control","LM_Time","LM_Active","LM_A_SE","LM_Control","LM_C_SE","LM_Delta","LM_D_SE","LM_Z","LM_P"))
  expect_identical(colnames(ccd),c("HR","LogHR","LogHR_SE","HR_Z","HR_P","LR_Z","LR_P","Events_Active","Events_Control","RMST_Restrict","RMST_Active","RMST_A_SE","RMST_Control","RMST_C_SE","RMST_Delta","RMST_D_SE","RMST_Z","RMST_P","LM_Time","LM_Active","LM_A_SE","LM_Control","LM_C_SE","LM_Delta","LM_D_SE","LM_Z","LM_P"))
  expect_identical(colnames(eee),c("RMST_Restrict","RMST_Active","RMST_A_SE","RMST_Control","RMST_C_SE","RMST_Delta","RMST_D_SE","RMST_Z","RMST_P"))
  expect_identical(colnames(jjj),c("HR","LogHR","LogHR_SE","HR_Z","HR_P","LR_Z","LR_P","Events_Active","Events_Control","LM_Time","LM_Active","LM_A_SE","LM_Control","LM_C_SE","LM_Delta","LM_D_SE","LM_Z","LM_P"))
})

test_that("summarise_analysis is working properly", {
  expect_true(is.matrix(cccc))
  expect_equal(nrow(cccc),1)
  expect_identical(colnames(cccc),c("Simulations","HR","LogHR","LogHR_SE","HR_Z","HR_P","HR_Power","HR_Failed","LR_Z","LR_P","LR_Power","LR_Failed","Events_Active","Events_Control","Events_Total","LM_Time","LM_Active","LM_A_SE","LM_Control","LM_C_SE","LM_Delta","LM_D_SE","LM_Power","LM_Failed"))
  expect_identical(colnames(eeee),c("Simulations","RMST_Restrict","RMST_Active","RMST_A_SE","RMST_Control","RMST_C_SE","RMST_Delta","RMST_D_SE","RMST_Power","RMST_Failed"))
})
context("Simulation analysis numerical testing")
test_that("numbers come out as expected", {
  expect_equal(as.numeric(cccc),tolerance=0.001,c(10,0.7609,-0.2733,0.25545,-1.0112,0.156,0.2,0,-1.0291,0.1517,0.2,0,22.2,56.2,78.4,10,0.881,0.0322,0.874,0.0234,0.007,0.0398,0.2,0))
  expect_equal(as.numeric(eeee),tolerance=0.001,c(10,10,9.3828,0.1931,9.4286,0.1253,-0.0458,0.2301,0.1,0))
})

context("Loading examples 4")
ep <- simulate_trials(active_ecurve=a,control_ecurve=a,active_dcurve=d,control_dcurve=d,rcurve=f,assess=30,iterations=1,seed=1234,detailed_output=FALSE)
lt1 <- summary(survfit(Surv(ep[,"Time"],1-ep[,"Censored"])~ 1,error="greenwood"))
lt <- cbind(lt1$time,lt1$n.risk,lt1$surv,lt1$std.err)
colnames(lt) <- c("Time","NAR","Survival","Std.Err")
fit1a <- fit_KM(lt,type="Weibull",weighting=TRUE,Weights="NAR",Weight_power=1,startbeta=1,startsigma=1)
fit1b <- fit_KM(lt,type="automatic",Survival="Survival",Time="Time",weighting=TRUE,Weights="NAR",Weight_power=1,startbeta=1,startsigma=1)
fit1c <- fit_KM(lt,type="Lognormal",weighting=TRUE,Weights="NAR",Weight_power=1,startbeta=1,startsigma=1)
fit2a <- fit_tte_data(ep,Event="Censored",censoringOne=TRUE,type="Weibull")
fit2b <- fit_tte_data(ep,Time="Time",Event="Censored",censoringOne=TRUE)
fit2c <- fit_tte_data(ep,Event="Censored",censoringOne=TRUE,type="Lognormal")

predict1a <- event_prediction_KM(KMcurve=lt,type="W",rcurve=f,max_time=100,discountHR=0.8,condition=TRUE,cond_Time=30,cond_Events=70,cond_NatRisk=230,units="M")
predict1c <- event_prediction_KM(KMcurve=lt,type="L",rcurve=f,max_time=100,condition=TRUE,cond_Time=30,cond_Events=70,cond_NatRisk=230,units="M")

predict2a <- event_prediction(data=ep,Event="Censored",censoringOne=TRUE,type="W",rcurve=f,max_time=100,discountHR=0.8,condition=TRUE,cond_Time=30,cond_Events=70,cond_NatRisk=230,units="M")
predict2b <- event_prediction(data=ep,Event="Censored",censoringOne=TRUE,rcurve=f,max_time=100,condition=TRUE,cond_Time=30,cond_Events=70,cond_NatRisk=230,units="M")

context("Curve fitting testing")
test_that("Curve fit outputs are correct", {
  expect_true(is.list(fit1a))
  expect_true(is.list(fit2a))
  expect_named(fit1c,c("Curvetype","Parameters","VCov","Fit"))
  expect_named(fit2c,c("Curvetype","Parameters","VCov","Fit"))
  expect_named(fit1b$Parameters,c("Alpha","Beta"))
  expect_named(fit2b$Parameters,c("Alpha","Beta"))
  expect_identical(as.character(fit1a$Curvetype),"Weibull")
  expect_named(fit1a$VCov,c("Alpha_Var","Beta_Var","Covariance"))
  expect_named(fit2c$VCov,c("Mu_Var","Sigma_Var","Covariance"))
  expect_equal(as.numeric(fit1a$Parameters),tolerance=0.0001,c(151.6121059,0.8715328))
  expect_equal(as.numeric(fit1c$Parameters),tolerance=0.000001,c(5.211939,2.187701))
  expect_equal(as.numeric(fit2a$Parameters),tolerance=0.000001,c(119.4294831,0.9492834))
  expect_equal(as.numeric(fit2c$Parameters),tolerance=0.000001,c(5.052680,2.156809))
  expect_equal(as.numeric(fit1b$VCov),tolerance=0.0001,c(102.3088,0.0006274441,-0.2489189))
  expect_equal(as.numeric(fit1c$VCov),tolerance=0.000001,c(0.008563819,0.006136131,0.007129209))
  expect_equal(as.numeric(fit2a$VCov),tolerance=0.000001,c(913.66525215,0.01456038,-3.05446988))
  expect_equal(as.numeric(fit2c$VCov),tolerance=0.000001,c(0.09259047,0.05473513,0.05859155))
})

context("event prediction testing")
test_that("event_prediction_km is working properly", {
  expect_true(is.list(predict1a))
  expect_named(predict1a,c("ecurve","dcurve","rcurve","Fitted","Summary"))
  expect_s4_class(predict1a$ecurve,"Curve")
  expect_s4_class(predict1a$dcurve,"Curve")
  expect_s4_class(predict1a$rcurve,"RCurve")
  expect_true(is.data.frame(predict1a$Summary))
  expect_named(predict1a$Summary,c("Time","Patients","Predicted_Events","Conditioned_Events"))
  expect_equal(as.numeric(predict1a$Summary[50,]),tolerance=0.001,c(50,300,83.972,102.512))
  expect_equal(as.numeric(predict1c$Summary[50,]),tolerance=0.001,c(50,300,90.115,100.452))
})

test_that("event_prediction_data is working properly", {
  expect_true(is.list(predict2a))
  expect_named(predict2a,c("ecurve","dcurve","rcurve","CI","Fitted","Summary"))
  expect_s4_class(predict2a$ecurve,"Curve")
  expect_s4_class(predict2a$dcurve,"Curve")
  expect_s4_class(predict2a$rcurve,"RCurve")
  expect_true(is.data.frame(predict2a$Summary))
  expect_named(predict2a$Summary,c("Time","Patients","Predicted_Events","SE_Fitting","SE_Prediction","Prediction_Lower","Prediction_Upper","Conditioned_Events","Cond_SE_Fitting","Cond_SE_Prediction","Cond_Prediction_Lower","Cond_Prediction_Upper"))
  expect_equal(as.numeric(predict2a$Summary[50,]),tolerance=0.001,c(50,300,79.906,9.6301,12.2904,57,105,99.187,5.3414,7.3410,86,115))
  expect_equal(as.numeric(predict2b$Summary[50,]),tolerance=0.001,c(50,300,96.288,12.1419,14.5712,69,126,105.887,7.1687,9.0252,90,125))
})
