% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gesis.R
\name{download_dataset}
\alias{download_dataset}
\title{Download a Gesis data set}
\usage{
download_dataset(s, doi, path = ".", filetype = ".dta", purpose = 1,
  quiet = FALSE)
}
\arguments{
\item{s}{A session object created with login()}

\item{doi}{The unique identifier(s) for the data set(s)}

\item{path}{Directory to which to download the file}

\item{filetype}{The filetype to download (usually available: .dta/.por/.sav)}

\item{purpose}{The purpose for downloading the data. See details.}

\item{quiet}{Whether to output download message.}
}
\value{
Nothing
}
\description{
Download a Gesis data set
}
\details{
Datasets reposited with GESIS are uniquely identified with a
  numberic identifier called a "DOI". This identifier appears both in the URL
  for a dataset's website, and on the website itself.

  In addition to accepting the terms of use, you need to input a purpose for
  downloading a data set. The options are as follows:

1. for scientific research (incl. PhD)
2. for reserach with commercial mandate
3. for teaching as lecturer
4. for my academic studies
5. for my final exam (e.g. bachelor or master)
6. for professional training and qualification
}
\examples{
\dontrun{s <- login("my_gesis_username", "my_gesis_password")
download_dataset(s, doi = "0078")}
}
