% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoneQ.R
\name{zoneQ}
\alias{zoneQ}
\title{zoneQ}
\usage{
zoneQ(contourSp, iC, iE, Z, K, simplitol = 0.001)
}
\arguments{
\item{contourSp}{contour line transformed into SpatialPolygons}

\item{iC}{zone to grow}

\item{iE}{englobing zone}

\item{Z}{zoning geometry (list of SpatialPolygons)}

\item{K}{zoning object (such as returned by calNei function)}

\item{simplitol}{tolerance for spatial polygons geometry simplification}
}
\value{
a zoning geometry updated with the grown zone(list of SpatialPolygons)
}
\description{
zoneQ
}
\details{
called by optiGrow,replaces the current zone by a bigger one
}
\examples{
data(mapTest)
qProb=c(0.3,0.5)
criti = correctionTree(qProb,mapTest)
K = criti$zk[[2]][[1]]
Z=K$zonePolygone
plotZ(Z)
iC=4
iE=detZoneEng(iC,Z,K$zoneNModif)
envel=calFrame(iC,Z,K$zoneNModif)
sp::plot(envel,add=TRUE,col="blue")
Qseq = genQseq(qProb,K,mapTest,iC,iE)
resi = geozoning:::findCinZ(iC,Z,K,mapTest,Qseq[5],envel)
Zopti=geozoning:::zoneQ(resi$contourSp,iC,iE,Z,K)
plotZ(Zopti)
}
\keyword{internal}
