% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractals.R
\name{gutenberg}
\alias{gutenberg}
\title{create a Gutenberg-Richter plot}
\usage{
gutenberg(m, n = 10, ...)
}
\arguments{
\item{m}{a vector of earthquake magnitudes}

\item{n}{the number of magnitudes to evaluate}

\item{...}{optional arguments to the generic \code{points}
function.}
}
\value{
the output of \code{lm} with earthquake magnitude as the
    independent variable (\code{mag}) and the logarithm (base 10)
    of the frequency as the dependent variable (\code{lfreq}).
}
\description{
Calculate a semi-log plot with earthquake magnitude on
    the horizontal axis,and the cumulative number of earthquakes
    exceeding any given magnitude on the vertical axis.
}
\examples{
data(declustered,package='geostats')
gutenberg(declustered$mag)
}
