% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional.R
\name{meanangle}
\alias{meanangle}
\title{mean angle}
\usage{
meanangle(trd, plg = 0, option = 0, degrees = FALSE)
}
\arguments{
\item{trd}{trend angle, in degrees, between 0 and 360 (if
\code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{plg}{(optional) plunge angle, in degrees, between 0 and 90
(if \code{degrees=TRUE}) or between 0 and \eqn{2\pi} (if
\code{degrees=FALSE}).}

\item{option}{scalar. If \code{option=0}, then \code{plg} is
ignored and the measurements are considered to be circular; if
\code{option=1}, then \code{trd} is the azimuth and \code{plg}
is the dip; if \code{option=2}, then \code{trd} is the strike
and \code{plg} is the dip; if \code{option=3} then \code{trd}
is the longitude and \code{plg} is the latitude.}

\item{degrees}{\code{TRUE} for degrees, \code{FALSE} for radians}
}
\value{
a scalar of 2-element vector with the mean orientation,
    either in radians (if \code{degrees=FALSE}), or in degrees.
}
\description{
Computes the vector mean of a collection of circular
    measurements.
}
\examples{
data(striations,package='geostats')
meanangle(striations,degrees=TRUE)
}
