% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostan_fit-methods.R
\name{print.geostan_fit}
\alias{print.geostan_fit}
\alias{plot.geostan_fit}
\alias{as.matrix.geostan_fit}
\alias{as.data.frame.geostan_fit}
\alias{as.array.geostan_fit}
\alias{residuals.geostan_fit}
\alias{fitted.geostan_fit}
\alias{spatial}
\alias{spatial.geostan_fit}
\alias{predict.geostan_fit}
\title{geostan_fit methods}
\usage{
\method{print}{geostan_fit}(
  x,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  digits = 3,
  pars = NULL,
  ...
)

\method{plot}{geostan_fit}(x, pars, plotfun = "hist", fill = "steelblue4", ...)

\method{as.matrix}{geostan_fit}(x, ...)

\method{as.data.frame}{geostan_fit}(x, ...)

\method{as.array}{geostan_fit}(x, ...)

\method{residuals}{geostan_fit}(object, summary = TRUE, rates = TRUE, detrend = TRUE, ...)

\method{fitted}{geostan_fit}(object, summary = TRUE, rates = TRUE, trend = TRUE, ...)

spatial(object, summary = TRUE, ...)

\method{spatial}{geostan_fit}(object, summary = TRUE, ...)

\method{predict}{geostan_fit}(
  object,
  newdata,
  alpha = mean(as.matrix(object, pars = "intercept")),
  center = object$x_center,
  summary = TRUE,
  type = c("link", "response"),
  ...
)
}
\arguments{
\item{x}{A fitted model object of class \code{geostan_fit}.}

\item{probs}{Argument passed to \code{quantile}; which quantiles to calculate and print.}

\item{digits}{number of digits to print}

\item{pars}{parameters to include; a character string (or vector) of parameter names.}

\item{...}{additional arguments.}

\item{plotfun}{Argument passed to \code{rstan::plot}. Options include histograms ("hist"), MCMC traceplots ("trace"), and density plots ("dens"). Diagnostic plots are also available such as Rhat statistics ("rhat"), effective sample size ("ess"), and MCMC autocorrelation ("ac").}

\item{fill}{fill color for histograms and density plots.}

\item{object}{A fitted model object of class \code{geostan_fit}.}

\item{summary}{Logical; should the values be summarized with the mean, standard deviation and quantiles (\code{probs = c(.025, .2, .5, .8, .975)}) for each observation? Otherwise a matrix containing samples from the posterior distribution at each observation is returned.}

\item{rates}{For Poisson and Binomial models, should the fitted values be returned as rates, as opposed to raw counts? Defaults to \code{TRUE}.}

\item{detrend}{For auto-normal models (CAR and SAR models with Gaussian likelihood only); if \code{detrend = TRUE}, the implicit spatial trend will be removed from the residuals. The implicit spatial trend is \code{Trend = rho * C \%*\% (Y - Mu)} (see \link[geostan]{stan_car} or \link[geostan]{stan_sar}). I.e., \code{resid = Y - (Mu + Trend)}.}

\item{trend}{For auto-normal models (CAR and SAR models with Gaussian likelihood only); if \code{trend = TRUE}, the fitted values will include the implicit spatial trend term. The implicit spatial trend is \code{Trend = rho * C \%*\% (Y - Mu)} (see \link[geostan]{stan_car} or \link[geostan]{stan_sar}). I.e., if \code{trend = TRUE}, \code{fitted = Mu + Trend}.}

\item{newdata}{A data frame in which to look for variables with which to predict, presumably for the purpose of viewing marginal effects. Note that if the model formula includes an offset term, \code{newdata} must contain a column with the appropriate name for the offset, even though the values will be ignored (you may set all values to 1); you must use the \code{alpha} argument to include any additional terms. Note also that any spatially-lagged covariate terms will be ignored if they were provided using the \code{slx} argument. If covariates in the model were centered using the \code{centerx} argument, the \code{predict.geostan_fit} method will automatically center the predictors in \code{newdata} internally using the values stored in \code{fit$x_center}. If \code{newdata} is missing, user arguments will be passed to the \code{fitted.geostan_fit} method to return the fitted values of the model.}

\item{alpha}{A single numeric value or a numeric vector with length equal to \code{nrow(newdata)}; \code{alpha} serves as the intercept in the linear predictor. The default is to use the posterior mean of the intercept. Even if \code{type = "response"}, this needs to be provided on the scale of the linear predictor. See \code{Details} for additional information.}

\item{center}{May be a vector of numeric values or a logical scalar to pass to \code{\link[base]{scale}}. Defaults to using \code{object$x_center}. If the model was fit using \code{centerx = TRUE}, then covariates were centered and their mean values are stored in \code{object$x_center} and the \code{predict} method will use them to automatically center \code{newdata}; if the model was fit with \code{centerx = FALSE}, then \code{object$x_center = FALSE} and \code{newdata} will not be centered.}

\item{type}{By default, results from \code{predict} are on the scale of the linear predictor (\verb{type = "link")}). The alternative (\code{type = "response"}) is on the scale of the response variable. For example, the default return values for a Poisson model are log-rates, and using \code{type = "response"} will return the rates (by exponentiating the log-rates).}
}
\value{
Methods \code{residuals}, \code{fitted}, \code{predict}, and \code{spatial} return a matrix containing all samples for each observation if \code{summary = FALSE}, else if \code{summary = TRUE} a \code{data.frame} containing a summary of the posterior distribution at each observation (of, respectively, residuals, fitted values, predicted values, or the spatial trend). The \code{predict} method will return a data frame with a summary of results together with use-provided \code{newdata}.

The \code{predict} method is designed for reviewing marginal effects of covariates. Thus, results do not include spatial trends or offset terms. To obtain the fitted values of the model (as opposed to predictions from new data), use the \code{fitted} method. For the posterior predictive distribution, see \code{\link[geostan]{posterior_predict}}.

\code{plot} returns a \code{ggplot} object that can be customized using the \code{ggplot2} package.

\code{as.matrix}, \code{as.data.frame}, \code{as.array} return samples from the joint posterior distribution of parameters in the format corresponding to their names. The \code{pars} argument is used to return samples from only a subset of parameters.
}
\description{
Methods for fitted geostan models: extract residuals, fitted values, posterior predictive distribution or spatial component from a spatial regression model; extract samples from the posterior distribution; print regression results; plot posterior distributions.
}
\details{
\subsection{predict.geostan_fit}{

The purpose of the predict method is to explore marginal effects of (combinations of) covariates. The method sets the intercept equal to its posterior mean (i.e., \code{alpha = mean(as.matrix(object, pars = "intercept"))}); the only source of uncertainty in the results is the posterior distribution of the coefficients, which can be obtained using \code{Beta = as.matrix(object, pars = "beta")}.

Be aware that in non-linear models (including Poisson and Binomial models) marginal effects of each covariate are sensitive to the level of other covariates in the model. If the model includes any spatially-lagged covariates (introduced using the \code{slx} argument) or a spatial autocorrelation term, these terms will essentially be fixed at zero for the purposes of calculating marginal effects. To explore the impact of these (missing) terms, you can add their values to the linear predictor using the \code{alpha} argument.
}
}
\examples{
\donttest{
data(georgia)
C <- shape2mat(georgia, style = "B")
cars <- prep_car_data(C)
georgia$income <- georgia$income/1e3

fit <- stan_car(deaths.male ~ offset(log(pop.at.risk.male)) + log(income),
                slx = ~ log(income),
                centerx = TRUE,
                car_parts = cars,
                data = georgia,
                family = poisson(),
                chains = 2, iter = 600) # for speed only


# print and plot results
print(fit)
plot(fit)

# residuals
r = resid(fit)

# fitted values 
# (Poisson model defaults to rates)
f1 = fitted(fit)
f2 = fitted(fit, rates = FALSE)

# spatial diagnostics
sp_diag(fit, georgia)

# spatial trend, county `random effects' 
sp = spatial(fit)

# posterior predictive distribution
yrep <- posterior_predict(fit, S = 65)
plot(density(yrep[1,]), col = "gray30")
for (i in 2:nrow(yrep)) lines(density(yrep[i,]), col = "gray30")
lines(density(georgia$deaths.male), col = "darkred", lwd = 2)

# array of samples; MCMC diagnostics
S.array <- as.array(fit, pars = c("intercept", "car_scale", "car_rho"))
S.monitor <- rstan::monitor(S.array, print = FALSE, warmup = 0)
head(S.monitor)

newdata <- data.frame(
    income = seq(min(georgia$income), max(georgia$income), by = 1),
    pop.at.risk.male = 1
)

p <- predict(fit, newdata, type = "response")
plot(newdata$income, p$mean * 1e3,
    type = 'l',
     main = "Deaths per 1,000",
     ylab = NA,
     xlab = "Median county income ($1,000s)")
}
}
\seealso{
\code{\link[geostan]{posterior_predict}}, \code{\link[geostan]{stan_glm}}, \code{\link[geostan]{stan_esf}}, \code{\link[geostan]{stan_icar}}, \code{\link[geostan]{stan_car}}
}
