% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSVirtualTable.R
\docType{class}
\name{GSVirtualTable}
\alias{GSVirtualTable}
\title{Geoserver REST API GSVirtualTable}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer virtual table
}
\description{
Geoserver REST API GSVirtualTable

Geoserver REST API GSVirtualTable
}
\examples{
GSVirtualTable$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{virtualTable}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSVirtualTable}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{name}

\item{\code{sql}}{SQL statement}

\item{\code{escapeSql}}{escape SQL?}

\item{\code{keyColumn}}{key column}

\item{\code{geometry}}{geometry}

\item{\code{parameters}}{list of virtual parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSVirtualTable-new}{\code{GSVirtualTable$new()}}
\item \href{#method-GSVirtualTable-decode}{\code{GSVirtualTable$decode()}}
\item \href{#method-GSVirtualTable-setName}{\code{GSVirtualTable$setName()}}
\item \href{#method-GSVirtualTable-setSql}{\code{GSVirtualTable$setSql()}}
\item \href{#method-GSVirtualTable-setEscapeSql}{\code{GSVirtualTable$setEscapeSql()}}
\item \href{#method-GSVirtualTable-setKeyColumn}{\code{GSVirtualTable$setKeyColumn()}}
\item \href{#method-GSVirtualTable-setGeometry}{\code{GSVirtualTable$setGeometry()}}
\item \href{#method-GSVirtualTable-addParameter}{\code{GSVirtualTable$addParameter()}}
\item \href{#method-GSVirtualTable-delParameter}{\code{GSVirtualTable$delParameter()}}
\item \href{#method-GSVirtualTable-clone}{\code{GSVirtualTable$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSVirtualTable}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-setSql"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-setSql}{}}}
\subsection{Method \code{setSql()}}{
Set SQL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$setSql(sql)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql}}{sql}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-setEscapeSql"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-setEscapeSql}{}}}
\subsection{Method \code{setEscapeSql()}}{
Set escape SQL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$setEscapeSql(escapeSql)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{escapeSql}}{escape SQL}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-setKeyColumn"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-setKeyColumn}{}}}
\subsection{Method \code{setKeyColumn()}}{
Set key column
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$setKeyColumn(keyColumn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyColumn}}{key column}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-setGeometry"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-setGeometry}{}}}
\subsection{Method \code{setGeometry()}}{
Set geometry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$setGeometry(vtg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vtg}}{object of class \link{GSVirtualTableGeometry}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-addParameter"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-addParameter}{}}}
\subsection{Method \code{addParameter()}}{
Adds parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$addParameter(parameter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter}}{object of class \link{GSVirtualTableParameter}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-delParameter"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-delParameter}{}}}
\subsection{Method \code{delParameter()}}{
Deletes parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$delParameter(parameter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter}}{object of class \link{GSVirtualTableParameter}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSVirtualTable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSVirtualTable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSVirtualTable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
