% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-binary-geometry.R
\name{geos_intersection}
\alias{geos_intersection}
\alias{geos_difference}
\alias{geos_sym_difference}
\alias{geos_union}
\alias{geos_intersection_prec}
\alias{geos_difference_prec}
\alias{geos_sym_difference_prec}
\alias{geos_union_prec}
\alias{geos_shared_paths}
\alias{geos_snap}
\alias{geos_clearance_line_between}
\title{Binary geometry operators}
\usage{
geos_intersection(geom1, geom2)

geos_difference(geom1, geom2)

geos_sym_difference(geom1, geom2)

geos_union(geom1, geom2)

geos_intersection_prec(geom1, geom2, grid_size)

geos_difference_prec(geom1, geom2, grid_size)

geos_sym_difference_prec(geom1, geom2, grid_size)

geos_union_prec(geom1, geom2, grid_size)

geos_shared_paths(geom1, geom2)

geos_snap(geom1, geom2, tolerance = .Machine$double.eps^2)

geos_clearance_line_between(geom1, geom2, prepare = FALSE)
}
\arguments{
\item{geom1, geom2}{\link[=as_geos_geometry]{GEOS geometry vectors},
recycled to a common length.}

\item{grid_size}{For \verb{_prec()} variants, the grid size such that all vertices of
the resulting geometry will lie on the grid.}

\item{tolerance}{The maximum separation of vertices that should
be considered equal.}

\item{prepare}{Use prepared geometries to calculate clearance line}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} along the recycled
length of \code{geom1} and \code{geom2}.
}
\description{
\itemize{
\item \code{\link[=geos_intersection]{geos_intersection()}} returns the set of points common to both \code{x}
and \code{y}.
\item \code{\link[=geos_difference]{geos_difference()}} returns the set of points from \code{x} that are
not contained by \code{y}.
\item \code{\link[=geos_sym_difference]{geos_sym_difference()}} returns the set of points that are \emph{not}
common to \code{x} and \code{y}.
\item \code{\link[=geos_union]{geos_union()}} returns the set of points contained by either \code{x}
or \code{y}.
\item \code{\link[=geos_shared_paths]{geos_shared_paths()}} returns a GEOMETRYCOLLECTION containing two
MULTILINESTRINGS: the first containing paths in the same direction,
the second containing common paths in the opposite direction.
\item \code{\link[=geos_snap]{geos_snap()}} snaps the vertices of \code{x} within \code{tolerance} of \code{y}
to \code{y}.
}
}
\examples{
poly1 <- "POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))"
poly2 <- "POLYGON ((5 5, 5 15, 15 15, 15 5, 5 5))"

geos_intersection(poly1, poly2)
geos_difference(poly1, poly2)
geos_sym_difference(poly1, poly2)
geos_union(poly1, poly2)

line <- "LINESTRING (11 0, 11 10)"
geos_snap(poly1, line, tolerance = 2)

geos_shared_paths("LINESTRING (0 0, 1 1, 2 2)", "LINESTRING (3 3, 2 2, 1 1)")

}
