% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_points.R
\name{line_ends}
\alias{line_ends}
\title{Extract End Points of a Line}
\usage{
line_ends(x)
}
\arguments{
\item{x}{\code{sf} line object}
}
\value{
\code{sf} point object
}
\description{
Extract End Points of a Line
}
\examples{
p1 <- data.frame(lon = -90.8, lat = 48.6) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")
profile_points(p1,
  profile.azimuth = 135, profile.length = 10000,
  crs = sf::st_crs("EPSG:26915")
) |>
  profile_line() |>
  line_ends()
}
