% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNVersion.R
\docType{class}
\name{GNVersion}
\alias{GNVersion}
\title{A GeoNetwork version}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoNetwork version
}
\description{
This class is an utility wrap the Geonetwork version
}
\details{
GeoNetwork REST API - GeoNetwork Version
}
\examples{
\dontrun{
version <- GNVersion$new("2.6.4")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GeoNetwork}
\keyword{version}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{version}}{version}

\item{\code{value}}{value}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GNVersion-new}{\code{GNVersion$new()}}
\item \href{#method-GNVersion-lowerThan}{\code{GNVersion$lowerThan()}}
\item \href{#method-GNVersion-greaterThan}{\code{GNVersion$greaterThan()}}
\item \href{#method-GNVersion-equalTo}{\code{GNVersion$equalTo()}}
\item \href{#method-GNVersion-clone}{\code{GNVersion$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNVersion-new"></a>}}
\if{latex}{\out{\hypertarget{method-GNVersion-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GNVersion}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNVersion$new(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNVersion-lowerThan"></a>}}
\if{latex}{\out{\hypertarget{method-GNVersion-lowerThan}{}}}
\subsection{Method \code{lowerThan()}}{
Compares to a version and returns TRUE if it is lower, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNVersion$lowerThan(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if lower, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNVersion-greaterThan"></a>}}
\if{latex}{\out{\hypertarget{method-GNVersion-greaterThan}{}}}
\subsection{Method \code{greaterThan()}}{
Compares to a version and returns TRUE if it is greater, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNVersion$greaterThan(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if lower, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNVersion-equalTo"></a>}}
\if{latex}{\out{\hypertarget{method-GNVersion-equalTo}{}}}
\subsection{Method \code{equalTo()}}{
Compares to a version and returns TRUE if it is equal, FALSE otherwise
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNVersion$equalTo(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if lower, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GNVersion-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GNVersion-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GNVersion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
