% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.utils.r
\name{na.omit.geomorph.data.frame}
\alias{na.omit.geomorph.data.frame}
\title{Handle missing values in rrpp.data.frame objects}
\usage{
\method{na.omit}{geomorph.data.frame}(object, ...)
}
\arguments{
\item{object}{object (from \code{\link{geomorph.data.frame}})}

\item{...}{further arguments (currently not used)}
}
\description{
Handle missing values in rrpp.data.frame objects
}
\examples{
data(plethspecies)
Y.gpa <- gpagen(plethspecies$land, verbose = TRUE)
gdf <- geomorph.data.frame(Y.gpa)
gdf$d <- Y.gpa$procD
gdf$group <- c(rep(1, 4), rep(2, 4), NA) # one unknown group designation
gdf
ndf <- na.omit(gdf)
ndf
}
\author{
Michael Collyer
}
\keyword{utilities}
