% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.Vrel.r
\name{integration.Vrel}
\alias{integration.Vrel}
\title{Quantify integration in a set of traits}
\usage{
integration.Vrel(A, phy = NULL)
}
\arguments{
\item{A}{A 3D array (p x k x n) containing Procrustes shape variables for all specimens, or a matrix (n x variables)}

\item{phy}{A phylogenetic tree of class = "phylo" - see \code{\link[ape]{read.tree}} in library ape}
}
\value{
Objects of class "rel.eig" from integration.Vrel return a list of the following:
 \item{Re.obs}{The observed relative eigenvalue index (Vrel).}
 \item{Z.obs}{The associated Z-score, which represents the effect size of Vrel.}
 \item{ZR}{The effect size translated to a positive scale (so that no integration is ZR = 0).}
 \item{ZR.var}{The variance of the effect size.}
}
\description{
Function quantifies the morphological integration in a set of traits
}
\details{
The function quantifies the strength of morphological integration in a set of variables. 
Here the set of traits are treated as a single unit, and the overall degree of covariation in them
is quantified using the relative eigenvalue index: Vrel (Pavlicev et al. 2009). Following 
Conaway and Adams (2022), only the non-trivial dimensions of variation are used in the calculation of Vrel. 
The measure is then converted to an effect size (Z-score), based on the procedures in Conaway and Adams (2022). 
These may be used in subsequent comparisons of the strength of integration across datasets. 
Input for the analysis may be a 3D array of Procrustes coordinates, of a matrix of variables. If the observations
 are species related by a phylogeny, the phylogeny may also be included.
}
\examples{
\dontrun{
data(plethodon) 
Y.gpa <- gpagen(plethodon$land)    #GPA-alignment    
integration.Vrel(Y.gpa$coords)
}
}
\references{
Pavlicev, M., J. M. Cheverud, and G. P. Wagner. 2009. Measuring morphological 
integration using eigenvalue variance. Evolutionary Biology 36:157-170.

Conaway, M.A., and D.C. Adams. 2022. An effect size for comparing the strength of 
  morphological integration across studies. Evolution. 76: 2244-2259.
}
\seealso{
\code{\link{compare.ZVrel}}
}
\author{
Dean Adams
}
\keyword{analysis}
