% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.modularity.r
\name{phylo.modularity}
\alias{phylo.modularity}
\title{Evaluate the degree of phylogenetic modular signal in Procrustes shape variables}
\usage{
phylo.modularity(
  A,
  partition.gp,
  phy,
  CI = FALSE,
  iter = 999,
  seed = NULL,
  print.progress = TRUE
)
}
\arguments{
\item{A}{A 3D array (p x k x n) containing Procrustes shape variables for all specimens, or a matrix (n x variables)}

\item{partition.gp}{A list of which landmarks (or variables) belong in which partition: 
(e.g. A, A, A, B, B, B, C, C, C)}

\item{phy}{A phylogenetic tree of {class phylo} - see \code{\link[ape]{read.tree}} in library ape}

\item{CI}{A logical argument indicating whether bootstrapping should be used for estimating confidence intervals}

\item{iter}{Number of iterations for significance testing}

\item{seed}{An optional argument for setting the seed for random permutations of the resampling procedure.
If left NULL (the default), the exact same P-values will be found for repeated runs of the analysis (with the same number of iterations).
If seed = "random", a random seed will be used, and P-values will vary.  One can also specify an integer for specific seed values,
which might be of interest for advanced users.}

\item{print.progress}{A logical value to indicate whether a progress bar should be printed to the screen.
This is helpful for long-running analyses.}
}
\value{
Objects of class "CR" from modularity.test return a list of the following:
   \item{CR}{Covariance ratio: The estimate of the observed modular signal.}
   \item{CInterval}{The bootstrapped 95 percent confidence intervals of the CR, if CI = TRUE.}
   \item{CR.boot}{The bootstrapped CR values, if CI = TRUE. 
   For more than two partitions, this is the mean CR of pairwise CRs.}
   \item{P.value}{The empirically calculated P-value from the resampling procedure.}
  \item{Effect.Size}{The multivariate effect size associated with sigma.d.ratio.}
   \item{CR.mat}{For more than two partitions, the pairwise CRs among partitions.}
   \item{random.CR}{The CR calculated in each of the random permutations of the resampling procedure.}
   \item{Pcov}{The phylogenetic transformation matrix, needed for certain other analyses.}
   \item{permutations}{The number of random permutations used in the resampling procedure.}
   \item{call}{The match call.}
}
\description{
Function quantifies the degree of modularity between two or more hypothesized modules of Procrustes shape variables
 in a phylogenetic context and compares this to patterns found by randomly assigning landmarks into subsets
}
\details{
The function quantifies the degree of phylogenetic modularity in two or more hypothesized modules of Procrustes shape variables as 
defined by landmark coordinates, under a Brownian motion model of evolution. The degree of modularity 
is characterized by the covariance ratio covariance ratio (CR: see Adams 2016). The phylogenetic version of the approach 
procedure utilizes the evolutionary covariance matrix among traits found under a Brownian
motion model of evolution as the basis of the analysis. This is the same matrix used to evaluate patterns of phylogenetic 
morphological integration as described in Adams and Felice (2014). 

Input may be either a 2D matrix of phenotypic values, or a 3D array of Procrustes shape variables. It 
is assumed that the landmarks have previously been aligned using Generalized Procrustes Analysis (GPA) [e.g., 
with \code{\link{gpagen}}]. The degree of modularity is quantified using the CR coefficient (Adams 2016). If more than 
two modules are defined, the average pairwise CR coefficient is utilized. The CR coefficient for the observed modular 
hypothesis is then compared to a distribution of values obtained by randomly assigning landmarks into subsets, with the 
restriction that the number of landmarks in each subset is identical to that observed in each of the original partitions. 
A significant modular signal is found when the observed CR coefficient is small relative to this distribution (see Adams 2016). 
Such a result implies that there is significantly greater independence among modules than is expected under the null 
hypothesis of random associations of variables (neither modular nor integrated structure). This  
result is consistent with the identification of significant modular structure in the data. For landmark data, the CR coefficient 
found from the average CR across a 90 degree rotation of the data is used as the test statistic (see Adams 2016). 
In addition, a multivariate effect size describing the strength of the effect is 
  estimated from the empirically-generated sampling distribution (see details in Adams and Collyer 2019).
}
\examples{
data(plethspecies)
Y.gpa<-gpagen(plethspecies$land)    #GPA-alignment
land.gps<-c("A","A","A","A","A","B","B","B","B","B","B") 

MT <- phylo.modularity(Y.gpa$coords, partition.gp=land.gps, 
phy=plethspecies$phy, 
CI = FALSE, iter=499)
summary(MT) # Test summary
plot(MT) # Histogram of CR sampling distribution 
}
\references{
Adams, D.C. 2016.Evaluating modularity in morphometric data: Challenges with the RV coefficient and a 
new test measure. Methods in Ecology and Evolution. 7:565-572.

Adams, D.C. and R. Felice. 2014. Assessing phylogenetic morphological 
integration and trait covariation in morphometric data using evolutionary covariance 
matrices. PLOS ONE. 9(4):e94335.

Adams, D.C. and M.L. Collyer. 2019. Comparing the strength of modular signal, and evaluating 
alternative modular hypotheses, using covariance ratio effect sizes with morphometric data. 
Evolution. 73:2352-2367.
}
\author{
Dean Adams
}
\keyword{analysis}
