% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.utils.r
\name{plot.gm.prcomp}
\alias{plot.gm.prcomp}
\title{Plot Function for geomorph}
\usage{
\method{plot}{gm.prcomp}(
  x,
  axis1 = 1,
  axis2 = 2,
  flip = NULL,
  phylo = FALSE,
  time.plot = FALSE,
  phylo.par = list(tip.labels = TRUE, node.labels = TRUE, anc.states = TRUE, node.pch =
    21, node.bg = "grey", node.cex = 1, edge.color = "black", edge.width = 1, tip.txt.cex
    = 1, tip.txt.col = "black", tip.txt.adj = c(-0.1, -0.1), node.txt.cex = 1,
    node.txt.col = "grey", node.txt.adj = c(-0.1, -0.1)),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{gm.prcomp}}}

\item{axis1}{A value indicating which PC axis should be displayed as the X-axis (default = PC1)}

\item{axis2}{A value indicating which PC axis should be displayed as the Y-axis (default = PC2)}

\item{flip}{An argument that if not NULL can be used to flip components in the plot.
The values need to match axis1 or axis2.  For example, if axis1 = 3 and axis2 = 4, flip = 1 will not
change either axis; flip = 3 will flip only the horizontal axis; flip = c(3, 4) will flip both axes.}

\item{phylo}{A logical value indicating whether the phylogeny should be projected to PC space}

\item{time.plot}{A logical value indicating if a 3D plot with the phylogeny and time as the 
z-axis is desired}

\item{phylo.par}{A list of plotting parameters for the inclusion of a phylogeny, including: logicals for 
whether features should be included (tip.labels, nodel.labels, anc.states), toggled as TRUE/FALSE; 
edge parameters (edge.color, edge.width, edge.lty); node parameters (node.bg, node.pch, node.cex);
and label parameters (tip.txt.cex, tip.txt.col, tip.txt.adj, node.txt.cex, node.txt.col, node.txt.adj).}

\item{...}{other arguments passed to plot.  For plots with a phylogeny, these parameters pertain to 
the tip values.}
}
\value{
An object of class "plot.gm.prcomp" is a list with components
 that can be used in other plot functions, such as the type of plot, points, 
 a group factor, and other information depending on the plot parameters used.  A time plot
 is an addendum to the normal 2D plot, and does not add additional output.
 
 NOTE: To visualize shape variation across PC axes in 2d plots, use \code{\link{picknplot.shape}}.
}
\description{
Plot Function for geomorph
}
\seealso{
\code{\link{plotRefToTarget}} \code{\link{picknplot.shape}}
}
\author{
Antigoni Kaliontzopoulou, Michael Collyer
}
\keyword{utilities}
\keyword{visualization}
