% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRefToTarget.r
\name{plotRefToTarget}
\alias{plotRefToTarget}
\title{Plot shape differences between a reference and target specimen}
\usage{
plotRefToTarget(
  M1,
  M2,
  mesh = NULL,
  outline = NULL,
  method = c("TPS", "vector", "points", "surface"),
  mag = 1,
  links = NULL,
  label = FALSE,
  axes = FALSE,
  gridPars = NULL,
  useRefPts = FALSE,
  ...
)
}
\arguments{
\item{M1}{Matrix of landmark coordinates for the first (reference) specimen}

\item{M2}{Matrix of landmark coordinates for the second (target) specimen}

\item{mesh}{A mesh3d object for use with {method="surface"}}

\item{outline}{An x,y curve or curves warped to the reference (2D only)}

\item{method}{Method used to visualize shape difference; see below for details}

\item{mag}{The desired magnification to be used when visualizing the shape difference (e.g., mag=2)}

\item{links}{An optional matrix defining for links between landmarks}

\item{label}{A logical value indicating whether landmark numbers will be plotted}

\item{axes}{A logical value indicating whether the box and axes should be plotted (points and vector only)}

\item{gridPars}{An optional object made by \code{\link{gridPar}}}

\item{useRefPts}{An option (logical value) to use reference configuration points rather than target configuration points (when {method = "TPS"})}

\item{...}{Additional parameters not covered by \code{\link{gridPar}} to be passed to \code{\link{plot}}, \code{\link{plot3d}} or \code{\link{shade3d}}}
}
\value{
If using {method="surface"}, function will return the warped mesh3d object.
}
\description{
Function plots shape differences between a reference and target specimen
}
\details{
The function generates a plot of the shape differences of a target specimen relative to a reference 
 specimen. The option {mag} allows the user to indicates the degree of magnification to be used when 
 displaying the shape difference. The function will plot either two- or three-dimensional data. 
 
 For two-dimensional data and thin-plate spline deformation plots, the user may also supply boundary 
 curves of the object, which will be deformed from the reference to the target specimen using the 
 thin-plate spline. Such curves are often useful in describing 
 the biological shape differences expressed in the landmark coordinates.  Note that to utilize this option, 
 a boundary curve from a representative specimen must first be warped to the reference specimen using
  \code{\link{warpRefOutline}}.
  
 Additionally, if a matrix of links is provided, the landmarks will be connected by lines.  
 The link matrix is an M x 2 matrix, where M is the desired number of links. Each row of the link matrix 
 designates the two landmarks to be connected by that link.
  
 Four distinct methods for plots are available:
 \enumerate{
 \item {TPS} a thin-plate spline deformation grid is generated. For 3D data, 
 this method will generate thin-plate spline deformations in the x-y and x-z planes. 
 \item {vector}: a plot showing the vector displacements between corresponding landmarks in the reference 
 and target specimen is shown. 
 \item {points} a plot is displayed with the landmarks in the target overlaying 
 those of the reference.  
 \item {surface} a mesh3d surface is warped using thin-plate spline (for 3D data only). 
 Requires mesh3d object in option {mesh}, made using \code{\link{warpRefMesh}}. 
 }
 This function combines numerous plotting functions found in Claude (2008).
}
\examples{
# Two dimensional data
data(plethodon) 
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment
ref<-mshape(Y.gpa$coords)
plotRefToTarget(ref,Y.gpa$coords[,,39])
plotRefToTarget(ref,Y.gpa$coords[,,39], mag=2, outline=plethodon$outline)   #magnify by 2X
plotRefToTarget(ref,Y.gpa$coords[,,39], method="vector", mag=3)
plotRefToTarget(ref,Y.gpa$coords[,,39], method="points", outline=plethodon$outline)
plotRefToTarget(ref,Y.gpa$coords[,,39], method="vector", outline=plethodon$outline, mag=2.5)
plotRefToTarget(ref,Y.gpa$coords[,,39], gridPars=gridPar(pt.bg = "green", pt.size = 1),
method="vector",mag=3)

# Three dimensional data
# data(scallops)
# Y.gpa<-gpagen(A=scallops$coorddata, curves=scallops$curvslide, surfaces=scallops$surfslide)
# ref<-mshape(Y.gpa$coords)
# plotRefToTarget(ref,Y.gpa$coords[,,1],method="points")
# scallinks <- matrix(c(1,rep(2:16, each=2),1), nrow=16, byrow=TRUE)
# plotRefToTarget(ref,Y.gpa$coords[,,1],gridPars=gridPar(tar.pt.bg = "blue", tar.link.col="blue",
# tar.link.lwd=2), method="points", links = scallinks)

}
\references{
Claude, J. 2008. Morphometrics with R. Springer, New York.
}
\seealso{
\code{\link{gridPar}}

\code{\link{define.links}}

\code{\link{warpRefMesh}}

\code{\link{warpRefOutline}}

\code{\link[rgl]{rgl-package}} (used in 3D plotting)
}
\author{
Dean Adams, Emma Sherratt, Antigoni Kaliontzopoulou & Michael Collyer
}
\keyword{visualization}
