% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readland.nts.r
\name{readland.nts}
\alias{readland.nts}
\title{Read landmark data matrix from nts file}
\usage{
readland.nts(file)
}
\arguments{
\item{file}{the name of a *.nts file containing two- or three-dimensional landmark data to be read in}
}
\value{
Function returns a 3D array (p x k x n), where p is the number of landmark points, k is the number 
  of landmark dimensions (2 or 3), and n is the number of specimens. The third dimension of this array 
  contains names for each specimen, which are obtained from the names in the *.nts file (if included).
}
\description{
Read single *.nts file containing landmark coordinates for a set of specimens
}
\details{
Function reads a single *.nts file containing two- or three-dimensional landmark coordinates for multiple specimens.

This is for NTS files of the "multiple specimen format" (details below), which is not the same as \code{\link{readmulti.nts}}.  
 
NTS files are text files in one of the standard formats for geometric morphometrics (see Rohlf 2012).
Multiple specimen format: 
  The parameter line contains 5 or 6 elements, and must begin with a "1" to designate a rectangular 
  matrix. The second and third values designate how many specimens (n) and how many total variables 
  (p x k) are in the data matrix. The fourth value is a "0" if the data matrix is complete and a "1" 
  if there are missing values. If missing values are present, the '1' is followed by the arbitrary 
  numeric code used to represent missing values (e.g., -999). These values will be replaced with "NA" 
  in the output array. Subsequent analyses requires a full complement of data, see \code{\link{estimate.missing}}. 
  The final value of the parameter line denotes the dimensionality of the landmarks
  (2,3) and begins with "DIM=". If specimen and variable labels are included, these are designated placing 
  an "L" immediately following the specimen or variable values in the parameter file. The labels then 
  precede the data matrix.
  
  Missing data may also be represented by designating them using 'NA'. In
  this case, the standard NTSYS header is used with no numeric designation for missing data (i.e. the fourth value is '0').
  The positions of missing landmarks may then be estimated using estimate.missing.

Special NTS files: *.dta files in the written by IDAV Landmark Editor, 
and *.nts files written by Stratovan Checkpoint have incorrect 
header notation; every header is 1 n p-x-k 1 9999 Dim=3, rather than 1 n p-x-k 0 Dim=3, which denotes
that missing data is in the file even when it is not. Users must change manually the header (in a text editor) before using this function
}
\references{
Rohlf, F. J. 2012 NTSYSpc: Numerical taxonomy and multivariate analysis system. Version 
  2.2. Exeter Software, New York.
}
\seealso{
\code{\link{readmulti.nts}}
}
\author{
Dean Adams & Emma Sherratt
}
\keyword{IO}
