% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.utils.r
\name{plot.procD.lm}
\alias{plot.procD.lm}
\title{Plot Function for geomorph}
\usage{
\method{plot}{procD.lm}(x, type = c("diagnostics", "regression", "PC"),
  outliers = FALSE, predictor = NULL, reg.type = c("CRC", "PredLine",
  "RegScore"), ...)
}
\arguments{
\item{x}{plot object (from \code{\link{procD.lm}})}

\item{type}{Indicates which type of plot, choosing among diagnostics,
regression, or principal component plots.  Diagnostic plots are similar to 
\code{\link{lm}} diagnostic plots, but for multivariate data.  Regression plots
plot multivariate dispersion in some fashion against predictor values. PC plots
project data onto the eigenvectors of the covariance matrix for fitted values.}

\item{outliers}{Logical argument to include outliers plot, if diagnostics
are performed}

\item{predictor}{An optional vector if "regression" plot type is chosen, 
and is a variable likely used in \code{\link{procD.lm}}.
This vector is a vector of covariate values equal to the number of observations.}

\item{reg.type}{If "regression" is chosen for plot type, this argument
indicates whether a common regression component (CRC) plot, prediction line 
(Predline) plot, or regression score (RegScore) plotting is performed.}

\item{...}{other arguments passed to plot (helpful to employ
different colors or symbols for different groups).  See
\code{\link{plot.default}} and \code{\link{par}}}
}
\value{
An object of class "plot.procD.lm" is a list with components
 that can be used in other plot functions, such as the type of plot, points, 
 a group factor, and other information depending on the plot parameters used.
}
\description{
Plot Function for geomorph
}
\author{
Michael Collyer
}
\keyword{utilities}
\keyword{visualization}
